/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>
*/

#if !defined(oagTimerWireModel_P)
#define oagTimerWireModel_P

#include "oaDesignDB.h"
#include "oagTimerModel.h"

using namespace oa;

namespace oagTimer {

/// Abstract class for representing wire loads and delays.
///
/// The user must extend this class by implementing the functions
/// which compute wire loads and delays.
///
/// \todo Expand this documentation.

class WireModel {
  public:
    WireModel() {
        // nothing
    }

    virtual ~WireModel() {
        // nothing
    }

  public:
    /// \todo We need more sophisticated methods here (i.e. caps
    /// depend on exact source and sink pins).
    virtual double getWireCap(oaNet *net) = 0;

    /// \todo We need more sophisticated methods here (i.e. delays
    /// depend on exact source and sink pins).
    virtual DelayType getWireDelay(oaNet *net) = 0;
};

}

#endif
