/************************************************************
* 
* File: oagTimerDuetSensitivity.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 09-02-2009
* Last Modified: Wed 06 Apr 2011 01:28:32 PM PDT
*
************************************************************/
#if !defined(oagTimerDuetSensitivity_P)
#define oagTimerDuetSensitivity_P

#include "oaDesignDB.h"
#include "oagTimerTimer.h"
#include "oagTimerSensitivity.h"
#include "oagTimerTPoint.h"
#include "oagTimerTPointMaster.h"
#include "oagTimerDesignTool.h"
#include "oagTimerCellData.h"

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;

struct SensType{
    oaModInst *modInst;
    oaOccInst *occInst;
    oaString name;
    double dPower;
    double dDelay;
    double sens;
};
/*---------------------------------------------------------*/
static bool incr_order (SenseData a, SenseData b){
    if(a.delta < b.delta)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr_order (SenseData a, SenseData b){
    if(a.delta > b.delta)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool incr (SensType a, SensType b){
    if(a.sens < b.sens)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr (SensType a, SensType b){
    if(a.sens > b.sens)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
class DuetSensitivity{
    public:
	DuetSensitivity(oaDesign* d,Timer* t);	
	~DuetSensitivity();

    public:
	void enableDebug();
	float getSensitivity(oaInst *old_inst, oaInst *new_inst);

	/* Call the specified duet test based 
	 amvuhtp on the argument passed
	 * @PARAM duetSensitivityType
	 */
	void duetTest(duetType type);
	void getDuetSensitivity(sensitivityList &list, duetType type);
    //private:
	//DelayType getDelay(oaOccInstTerm* instTermObject);
	DelayType getDelay(oaModInst* inst);
	DelayType getSlack(Timer *timing, oaOccInstTerm* instTermObject);
    public:
	void run();
    private:
	void resetUpdList();
	void markInst(oaOccInst *inst);
	void updateSensList();
	bool needUpdate(oaOccInst* i);
	void splitCurrList();

	void createSensList();
	void getSensData(CellData *c);
	void remove(oaModInst* currInst);
	void mergeList();

	list<SensType> sensList;
	list<SensType> sensList_temp;
	list<SensType> bestList;
	list<SensType> regList;

	//Debug
	void printSensList();
	void print(SensType s);

	sensitivityList createSwapList(duetType type);
	void find_and_remove(oaModInst* currInst,sensitivityList &list);
	void updateSwapList(oaModInst* inst,sensitivityList &list);
	void initDesign();
	void removeVisited(oaModInst* inst);
	void getOtherCells(vector<oaString> &list);
	void getDownSizePowerDelaySensitivities(sensitivityList &list, CellData *c);

	/*For DEBUG ONLY*/
	void printDuetList(sensitivityList list, duetType type,int pos);
    public:
	bool flag;
    private:
	oaDesign *design;
	Timer *timing;
	bool debug_flag;
	Util ut;
	vector<oaModInst*> Design_list;
	map<oaOccInst*,int> toUpdMap;
	//int capacity;
	//
	//For statistics
	int numOfRoots;
	int numOfRootsWithgreaterFO4;
	int numOfRootsWithgreaterDepth10;
	int numOfRootsWithgreaterDepth20;
	int maxDepth;
	int maxFanout;
};
/*---------------------------------------------------------*/
} //namespace
#endif
