/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
2005-07-17: Moved from Timer class
*/

#include "oagUtilGlobMatch.h"

namespace oagUtil {

GlobMatch::GlobMatch(const std::string &pattern) :
    _pattern(pattern)
{
    // do nothing
}

bool
GlobMatch::match(const std::string &s) {
    return _recursiveMatch(_pattern, s);
}

bool
GlobMatch::_recursiveMatch(const std::string &pattern,
                           const std::string &name)
{
    if (pattern.empty()) {
        return (name.empty());
    }

    if (pattern[0] == '?') {
        if (name.empty()) {
            return false;
        }
        std::string ns1(pattern), ns2(name);
        ns1.erase(ns1.begin(), ns1.begin() + 1);
        ns2.erase(ns2.begin(), ns2.begin() + 1);
        return _recursiveMatch(ns1, ns2);
    } else if (pattern[0] == '*') {
        std::string ns1(pattern);
        ns1.erase(ns1.begin(), ns1.begin() + 1);
        for (unsigned i = 0; i <= name.size(); i++) {
            std::string ns2(name);
            ns2.erase(ns2.begin(), ns2.begin() + i);
            if (_recursiveMatch(ns1, ns2)) {
                return true;
            }
        }
        return false;
    } else {
        if (name.empty()) {
            return false;
        }
        if (pattern[0] != name[0]) {
            return false;
        }
        std::string ns1(pattern), ns2(name);
        ns1.erase(ns1.begin(), ns1.begin() + 1);
        ns2.erase(ns2.begin(), ns2.begin() + 1);
        return _recursiveMatch(ns1, ns2);
    }
}

}
