/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-11-18: ChangeLog started
*/

#include <stdio.h>
#include <iostream>
#include <istream>
#include <fstream>
#include <map>
#include <string>
#include <ctype.h>
#include <sstream>

#include "oaDesignDB.h"

using std::cout;
using std::endl;
using std::cerr;
using std::istream;
using std::ifstream;
using std::string;
using std::map;
using std::stringstream;

using oa::oaPoint;
using oa::oaBlock;
using oa::oaNativeNS;
using oa::oaIter;
using oa::oaString;
using oa::oaInst;
using oa::oaScalarName;
using oa::oaCellView;
using oa::oaDesignInit;
using oa::oaLibDefList;
using oa::oaDesign;
using oa::oaException;

bool isEmpty(char blah[])
{
  bool rval=true;
  int i=0;
  while(rval && blah[i] != 0)
  {
    rval = rval && !isspace(blah[i++]);
  }
  return rval;
}

//TODO: write (or steal) a better parser
map< string, oaPoint > readPl (istream& pl)
{
  char blah[4096];  //TODO: istream::getline sucks
  map< string, oaPoint > rval;
  //Gobble first line
  pl.getline(blah,4096);
  string name;
  double x,y;
  while(pl.good())
  {
    pl.getline(blah,4096);
    if(blah[0]=='#')  continue;
    if(isEmpty(blah)) continue; 
    stringstream ss;
    ss << blah;
    ss >> name >> x >> y;
    rval[name]=oaPoint(static_cast<int>(x),static_cast<int>(y));
  }  
  cout << "finished parsing" << endl;
  return rval;
}

void
writePlFile( const oaBlock *block, istream& pl)
{
  oaNativeNS     ns;
  map<string,oaPoint> inPl = readPl(pl); 
  cout << "writing locations to the db ..." << endl;
/*
  oaIter<oaTerm> itIter(block->getTerms());
  while (oaTerm   *term = itIter.getNext()) 
  {
    oaString        iStr;
    term->getName(ns, iStr);
    map<string,oaPoint>::const_iterator it = inPl.find(string(static_cast<const char *>(iStr)));
    if(it!=inPl.end())
      term->setOrigin(it->second);
    else
    {
      cerr << "Cannot find node "<<iStr<<" in pl file." <<endl;
      assert(0);
    } 
  }
*/
  oaIter<oaInst> iIter(block->getInsts());
  while (oaInst   *inst = iIter.getNext()) 
  {
    oaString        iStr;
    inst->getName(ns, iStr);
    map<string,oaPoint>::const_iterator it = inPl.find(string(static_cast<const char*>(iStr)));
    if(it!=inPl.end()) 
    {
      inst->setOrigin(it->second);
      cout<<iStr<<" ("<<it->second.x()<<","<<it->second.y()<<")."<<endl;
    }
    else
    {
      cerr << "Cannot find node "<<iStr<<" in pl file." <<endl;
      assert(0);
    } 

  }
  
  cout << "finished successfully! "<<endl;
}


int main(int   argc, char  *argv[])
{
    try 
    {
        oaDesignInit();
        oaLibDefList::openLibs();



        // Check number of arguments.
        if ( argc < 5 ) {
            printf(" Use : \n\toaWritePl libraryName cellName viewName plName\n");
            exit(1);
        }

        // Get the names from the command line
        oaString        libstr(argv[1]);
        oaString        cellstr(argv[2]);
        oaString        viewstr(argv[3]);

        // Treat the names on the command line as belonging to the Native
        // namespace and convert them to oaNames.
        oaNativeNS      ns;
        oaScalarName    libName(ns, libstr);
        oaScalarName    cellName(ns, cellstr);
        oaScalarName    viewName(ns, viewstr);

        oaDesign      *des;

        try {
            des = oaDesign::open(libName, cellName, viewName, 'a');
        }
        catch (oaException &excp) {
            printf("Can't read CellView %s %s %s (check cds.lib)\n", (const char *)libstr,
                    (const char *)cellstr, (const char *)viewstr);
            printf("\t%s\n", (const char *)excp.getMsg());
            exit(1);
        }

        printf( "Reading CellView %s %s %s\n",
                (const char *)libstr,
                (const char *) cellstr,
                (const char *) viewstr );
        // Write the dump to a file with a named as a concatenation of cell and view names.
        char * plFname = argv[4];
        ifstream inPlF;

        printf("Writing pl locations to Cell View\n");

        // Now dump all selected objects in the CellView
        try {
            oaBlock *block = des->getTopBlock();

            inPlF.open(plFname); 
            writePlFile  (block, inPlF);
            inPlF.close();

        }
        catch (oaException &excp) {
            printf("Error: %s\n", (const char *)excp.getMsg());
            exit(1);
        }

        try
        {
            des->save();
        }
        catch (oaException &excp) {
            printf("Error: %s\n", (const char *)excp.getMsg());
            exit(1);
        }
        exit(0);
        return 0;
    }
    catch (oaException &excp) {
        printf("Error: %s\n", (const char *)excp.getMsg());
        exit(1);
    }
}

