/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

// Author: Zhong Xiu <zxiu@andrew.cmu.edu>

#include "oagTimerTermObserver.h"
#include "oagTimerTimer.h"
#include "oagTimerTPoint.h"

namespace oagTimer {

using namespace oa;

///////////////////////////////////////////////////////////////////////////////

TermObserver::TermObserver(oaUInt4      priority,
                           oaBoolean    enabled) :
    oaObserver<oaOccTerm>(priority, enabled)
{
    // do nothing
}

///////////////////////////////////////////////////////////////////////////////

void
TermObserver::onPostCreate(oaOccTerm *term)
{
    TPoint::create(term);
};

///////////////////////////////////////////////////////////////////////////////

void
TermObserver::onPreModify(oaOccTerm         *term,
                          oaTermModTypeEnum modType)
{
    if (modType == oacMoveToNetTermModType) {
        invalidate(term);
    }
};

///////////////////////////////////////////////////////////////////////////////

void
TermObserver::onPostModify(oaOccTerm            *term,
                           oaTermModTypeEnum    modType)
{
    if (modType == oacSetTermTypeTermModType ||
        modType == oacMoveToNetTermModType) {
        invalidate(term);
    }
};

///////////////////////////////////////////////////////////////////////////////

void
TermObserver::onPreDestroy(oaOccTerm *term)
{
    TPoint::destroy(term);
};

///////////////////////////////////////////////////////////////////////////////

void
TermObserver::invalidate(oaOccTerm *term)
{
    oaOccNet *n = term->getNet();
    assert(n);
    Timer::invalidateFanout(n);
    Timer::invalidateFanin(n);
}

///////////////////////////////////////////////////////////////////////////////

}
