/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <assert.h>
#include <iostream>
#include "oaDesignDB.h"

#include "oagTimerModel.h"
#include "oagTimerTPointMaster.h"

namespace oagTimer {

///////////////////////////////////////////////////////////////////////////////

oaVoidPointerAppDef<oaModTerm> *TPointMaster::_termAppDef = 0;

///////////////////////////////////////////////////////////////////////////////
/// Destructor.

TPointMaster::~TPointMaster()
{
    for (modelVector::iterator i = _models.begin();
         i != _models.end(); ++i) {
        ModelType *m = *i;
        assert(m);
        delete m;
    }
}

///////////////////////////////////////////////////////////////////////////////

void
TPointMaster::initAppDefs()
{
    assert(!_termAppDef);
    _termAppDef = oaVoidPointerAppDef<oaModTerm>::get("oagTimerMasterTerm");
    assert(_termAppDef);
}


///////////////////////////////////////////////////////////////////////////////
TPointMaster *
TPointMaster::create(oaModTerm *term)
{
    assert(term);
    assert(!_termAppDef->get(term));
    TPointMaster *tpm = new TPointMaster();
    _termAppDef->set(term, static_cast<void *>(tpm));
    return tpm;
}

///////////////////////////////////////////////////////////////////////////////
TPointMaster *
TPointMaster::get(oaModTerm *term)
{
    assert(term);
    TPointMaster *tpm = static_cast<TPointMaster *>
        (_termAppDef->get(term));
    return tpm;
}

///////////////////////////////////////////////////////////////////////////////

void
TPointMaster::_makePath(TimerPath       &p,
                        oaModTerm       *term, 
                        const ModelType *delay, 
                        const ModelType *slew, 
                        int             transition) 
{
    assert(term);
    assert(delay);
    p.other = term;
    p.delay = new ModelType(*delay);
    _models.push_back(p.delay);
    if (slew) {
        p.slew = new ModelType(*slew);
        _models.push_back(p.slew);
    } else {
        p.slew = 0;
    }
    p.transition = transition;
}

///////////////////////////////////////////////////////////////////////////////

void
TPointMaster::addInPath(oaModTerm       *term,
                        const ModelType *delay, 
                        const ModelType *slew, 
                        int             transition) 
{
    TimerPath p;
    _makePath(p, term, delay, slew, transition);
    inPaths.push_back(p);
}

///////////////////////////////////////////////////////////////////////////////

void
TPointMaster::addOutPath(oaModTerm          *term,
                         const ModelType    *delay, 
                         const ModelType    *slew, 
                         int                transition) 
{
    TimerPath p;
    _makePath(p, term, delay, slew, transition);
    outPaths.push_back(p);
}

///////////////////////////////////////////////////////////////////////////////

}
