/************************************************************
* oagTimerSensitivity.h
* Authors: Santiago Mok <smok@ee.ucla.edu>
*
*
************************************************************/

#if !defined(oagTimerSensitivity_P)
#define oagTimerSensitivity_P

#include <iostream>
#include <vector>
#include <list>
#include <algorithm>
#include <string.h>
#include "oaDesignDB.h"
#include "oagTimerTPointMaster.h"
#include "oagTimerUtil.h"
#include "oagTimerLibParserInt.h"
#include "oagTimerTimer.h"

namespace oagTimer {

using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
/* Types of Sensitivity */
typedef enum{
    SOLO_POWER,
    DUET_POWER_DELAY,
    DUET_POWER_SLACK,
    DUET_POWER_SLACK_RATIO
} duetType;
/*---------------------------------------------------------*/
/*! This struct hold the neccesary information of the reference gates and it power sensitivity value */
struct SenseData{
    oaModInst *inst;
    oaString currInst;
    oaString newInst;
    double delta;
    bool zero_delta_slack;

    /* Debug Purposes*/
    double delta_power;
    double delta_slack;
    DelayType delta_delay;
    DelayType delay_new;
    DelayType delay_current;
    DelayType slack_new;
    DelayType slack_current;
/*    bool operator() (const SenseData &s1, const SenseData &s2){
	return (s1.delta < s2.delta);
    } */
};
/*! This is a vector of sensitivity data */
//typedef vector<SenseData> senseDataVector;
typedef list<SenseData> sensitivityList;
/*---------------------------------------------------------*/
class Sensitivity {
    public:
	Sensitivity(){
	    //nothing
	}
	virtual ~Sensitivity(){
	    //nothing
	}

    public:
	//void sort();
	virtual float getSensitivity(oaInst *inst1, oaInst *inst2) = 0;
	float getSensitivity(const char *inst_old, const char *inst_new);
	//float getDuetSensitivity(const char *inst_old, const char *inst_new,sensitivityType type);
	sensitivityList createSwapList(oaDesign* design,int decrease_only);
	void getMatchCells(vector<oaString> &list);
	void find_and_remove(oaModInst* currInst,sensitivityList &list);
	int updateSwapList(oaModInst* inst,sensitivityList &list,int decrease_only);
	void invalidate_swapCell(oaDesign* design,Timer* t,oaModScalarInst *m);
	oaOccInstTerm* findOccOutputTerm(oaDesign *design, oaModScalarInst *m);
};
/*---------------------------------------------------------*/
    
}//namespace
#endif
