/************************************************************
* oagTimerPowerSenseOpt.cpp
* Perform gate sizing algorithm based on power sensitivity
* test with incremental timing analysis
* by: Santiago Mok <smok@ee.ucla.edu>
* advised by: Prof. Puneet Gupta
* Electrical Engr Dept, UCLA
*
************************************************************/

#include <assert.h>
#include <iostream>
#include <algorithm>
#include <time.h>
#include "oaDesignDB.h"
#include "oagTimerLibParserInt.h"
#include "oagTimerPowerSenseOpt.h"
#include "oagTimerTPointMaster.h"
#include "oagTimerReport.h"
#include "oagTimerUtil.h"

#include <list>
#define MODE_READ 'r'

namespace oagTimer {

/*---------------------------------------------------------*/

using namespace oa;
using namespace std;

/*---------------------------------------------------------*/

//Constructor
PowerSenseOpt::PowerSenseOpt(){
    //liberty = libertyLib;
    u = new Util();
}

//Destructor
PowerSenseOpt::~PowerSenseOpt(){
    delete u;
}
/*---------------------------------------------------------*/
void
PowerSenseOpt::reverseSwap(SenseData s){
    int status = u->swapCell(s.currInst,s.inst);
    if(status != 0){
	std::cerr << "Error: swapping cell " << s.currInst << std::endl;
	exit(1);
    }
}
/*---------------------------------------------------------*/
void
PowerSenseOpt::Opt(oaDesign* des, Timer *t, duetType type){

    design = des;
    timing = t;
    sensitivityList list;
    list.clear();
    oaNativeNS NS;
    
    double dif;
    time_t start, end;
    time (&start);
    //double t;

    cout << "Initial Cell Leakage:" << Util::getTotalLeakPower(design) << endl;
    
    list = createSwapList(design,1);
    list.sort(compare_psense);

    /*sensitivityList::iterator iter;
    iter = list.begin();
    SenseData t1 = *iter;
    oaModInst *i = t1.inst;
    std::cout << (i->getName(NS,instName),instName) << std::endl;
    Sensitivity::find_and_remove(t1.inst,list);*/

    int count = 0;
    //while(!pSenseData.empty() &&  dif < 500.0){
    while(!list.empty()){
    //Debug
	int row_count = 0;
	SenseData _s = list.back();
	list.pop_back();

//Print Current Swap
	u->swapCell(_s.newInst, _s.inst);
		
	//Incremental Timing Analysis
	//cout << "***  INVALIDATE ****" << endl;
	oaOccInstTerm* outputTerm = u->findOccOutTerm(
		design,static_cast<oaModScalarInst*>(_s.inst));
	u->invalidateFanIOTiming(design,timing,_s.inst);
	
	timing->updateAll();
	//cout << "***  END INVALIDATE ****" << endl;

	//DelayType slack_value = timing->getFullSlack(occOutputTerm);
	DelayType slack = u->getIOSlack(_s.inst,design,timing,OUTPUT); 
	DelayType worst_slack = timing->getWorstSlack();
	
	if(slack > 0 && worst_slack >= 0 && _s.delta < 0){
	    //cout << "Move Taken" << endl; 
	    //Sensitivity::find_and_remove(inst,list);
	    //updateSwapList(inst,list,1);
	    list = createSwapList(design,1);
	    list.sort(compare_psense);
	} else { 
	    //cout << "Move Reversed" << endl;
	    reverseSwap(_s);
	    u->invalidateFanIOTiming(design,timing,_s.inst);
	    timing->updateAll();
	}
	/*
	std::cout << "***SLACK:" << slack_value << "***" << endl;
	cout << "Delta LeakagePower:" << _s.delta << endl;
	cout << "****** COUNT " << ++count << " ******" << endl;
	cout << "***************** END SWAP ***************************" << endl;
*/
    }
    time (&end);
    cout << "Final CellLeakage:" << Util::getTotalLeakPower(design) << endl;
    cout << "Time:" << dif << endl;
}
/*---------------------------------------------------------*/
sensitivityList
PowerSenseOpt::createSwapList(oaDesign* design, bool decrease_only){
    oaNativeNS NS;
    oaString headerName;
    sensitivityList list;
    list.clear();

    assert(design);
    oaModule *mod = design->getTopModule();
    
    assert(mod);
    oaIter<oaModInst> modIter ( mod->getInsts());
    while(oaModInst *modInst = modIter.getNext()){
	oaString masterName = u->getCellName(modInst);
	vector<oaString> cellList;
	cellList.clear();
	cellList.push_back(masterName);
	u->getMatchCells(cellList,0);
	//cout << cellList.size() << std::endl;
	while(!cellList.empty()){
	    oaString cellName = cellList.back();
	    cellList.pop_back();
	    SenseData d;
	    d.inst = modInst;
	    d.currInst = masterName;
	    d.newInst = cellName;
	    d.delta_power = d.delta = Util::getPowerSensitivity(masterName,cellName);
	    if(decrease_only && d.delta >= 0)
		continue;
	    list.push_back(d);
	}
    }
    return list;
}
/*---------------------------------------------------------*/
void
PowerSenseOpt::printCurrList(sensitivityList list){
    int id = 0;
    std::cout << "Now List Contains:" << std::endl;
    sensitivityList::iterator it;
    for(it = list.begin(); it != list.end(); ++it){
	std::cout << ++id << ")"  << Util::getInstName(it->inst) 
	    << "-Gate1:" << it->currInst
	    << "-Gate2:" << it->newInst
	    << "-PowerSense:" << it->delta << std::endl;
    }
}
/*---------------------------------------------------------*/
	//cout << (inst->getName(NS,instName),instName) << endl;
	//cout << "OrigitanlGate:" << _s.currInst << endl;
	//cout << "SwapGate:" << _s.newInst << endl;
	//cout << "  DeltaLeakPwr:" << _s.delta << endl;
/*---------------------------------------------------------*/
}//namespace
