/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
2005-08-05: Moved to separate file
*/

#if !defined(oagTimerInstTermObserver_P)
#define oagTimerInstTermObserver_P

#include "oaDesignDB.h"

namespace oagTimer {

/*! \brief Incremental timing callback class.

    This class is derived from the oaObserver class. 
    The purpose of this class is to catch changes to the netlist and
    invalidate any TimingPoints which are affected.
*/
class InstTermObserver : public oa::oaObserver<oa::oaOccInstTerm>
{
  public:
    /*! Constructor.

        \param priority Priority level for callback ordering.
        \param enabled True if the callback should be enabled.
    */
    InstTermObserver(oa::oaUInt4    priority,
                     oa::oaBoolean  enabled = true);

    /*! Callback after instTerm is created.

        \param instTerm The newly created instTerm.
    */
    void onPostCreate(oa::oaOccInstTerm *instTerm);

    /*! Callback before instTerm is modified.

        \param instTerm The modified instTerm.
        \param modType The modification type.
    */
    void onPreModify(oa::oaOccInstTerm          *instTerm,
                     oa::oaInstTermModTypeEnum  modType);

    /*! Callback after instTerm is modified.

        \param instTerm The modified instTerm.
        \param modType The modification type.
    */
    void onPostModify(oa::oaOccInstTerm         *instTerm,
                      oa::oaInstTermModTypeEnum modType);

    /*! Callback before instTerm is destroyed.

        \param instTerm The instTerm to be destroyed.
    */
    void onPreDestroy(oa::oaOccInstTerm *instTerm);

  private:
    void invalidate(oa::oaOccInstTerm *instTerm);
};

}

#endif
