/************************************************************
* 
* File: oagTimerDP.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 03-05-2011
* Last Modified: Thu 24 Mar 2011 01:45:36 PM PDT
*
************************************************************/

#include "oagTimerDP.h"
#include "oagTimerUtil.h"
#include "oagTimerDesignTool.h"
#include "oagTimerLibParserInt.h"
#include "oagTimerSubTimer.h"

#include "assert.h"
#include <time.h>
#include <vector>

//#define DEBUG
//#define DEBUG1
//#define DEBUGFree
namespace oagTimer{

using namespace oa;
using namespace std;

/*---------------------------------------------------------*/
DP::DP(oaDesign *d, Timer *t){
      design = d;
      timing = t;
      iterRefine = false;
};
/*---------------------------------------------------------*/
DP::~DP(){}
/*---------------------------------------------------------*/
void
DP::run(){
    time_t start; 
    time_t end;
    time (&start);

    std::cout << "Initial timing:" << timing->getWorstArr() 
	<< " target:" << timing->getPeriod() << std::endl;
    bool timingImprove;
    bool flag = false;
    double initialTiming = timing->getPeriod();
    double prevTiming = timing->getWorstArr();
    double factor = 1.0;
    do{
	targetDelay = prevTiming;
	timingImprove = false;
	std::cout << "Initial timing:" << timing->getWorstArr() 
	    << " given target:" << targetDelay << std::endl;
	/* Initial Data Check*/
	DpRelaxation();
	DpRestoration();

	//assignDPSolutions;
	
	/*if(dpSolutions.empty()) std::cout << "No DP Solution" << std::endl;
	map<oaOccInst*, oaString>::iterator iter;
	for(iter=dpSolutions.begin(); iter!=dpSolutions.end(); iter++){
	    CellData *cell = CellData::get(iter->first->getModInst());
	    assert(cell);
	    oaString newSize = iter->second; 
	    if(newSize == cell->master->name) continue;

	    cell->swap(newSize);
	    cell->commitSwap();
	}
	timing->clearDesignTimingData();
	timing->updateAll();
	*/
	double currTiming = timing->getWorstArr();
	if( currTiming < prevTiming){
	    timingImprove = true;
	    prevTiming = currTiming;
	    std::cout << " UpdatedTiming:" << timing->getWorstArr() << std::endl;
	}else{
	    if(!flag){
		prevTiming = prevTiming*0.95;
		timingImprove = true;
		flag = true;
	    }
	}

	//ERASE OF DPDATA*
	oaOccurrence *occ = design->getTopOccurrence();
	oaIter<oaOccInstTerm> itIter = occ->getInstTerms();
	while(oaOccInstTerm *i = itIter.getNext()){
	    TPoint *tp = TPoint::get(i);
	    for(int i=0; i<tp->pinDPData.size(); i++){
		tp->pinDPData[i]->faninMap.clear();
		clearDPData(tp->pinDPData[i]);
	    }
	    tp->pinDPData.clear();
	    tp->dpIndex = -1;
	    tp->dpArr = -DBL_MAX;
	    tp->DPSolutions.clear();
	}
	//iterRefine = true;
    }while(timingImprove);

    time (&end);
    std::cout << "Total Runtime:" << difftime(end,start) << " (s)" << std::endl;
}
/*---------------------------------------------------------*/
void
DP::DpRelaxation(){
#if defined(DEBUG)
    std::cout << "DpRelaxation()" << std::endl;
#endif
    vector<oaModInst*> revTop = DesignTool::getReverseTopological(design,timing); 
    //for each gate in reverse topological order
    flag = false;
    for(int i=0; i<revTop.size(); i++){
	//std::cout << Util::getInstName(revTop[i]) << std::endl;
	CellData *cell = CellData::get(revTop[i]);
	assert(cell);
	//std::cout << "Curr:" << cell->instName << std::endl;
	oaOccInstTerm *instTerm = DesignTool::getOccOutInstTerm(cell->occInst);
	TPoint *outPin = TPoint::get(instTerm);
	assert(outPin);
	mergeFanoutSolutions(instTerm);
	vector<DPData*> fanoutsData = outPin->pinDPData;
	 
	vector<oaString> sizesData = cell->getAllSizes(); 
	oaIter<oaOccInstTerm> itTerm = cell->occInst->getInstTerms();
	while(oaOccInstTerm *iTerm = itTerm.getNext()){
	    TPoint *currPin = TPoint::get(iTerm);
	    assert(currPin);
	    if(currPin->type == TIMING_POINT_SIGNAL_IN){
		for(int j=0; j<sizesData.size(); j++){	 //for all size options
		    /*std::cout << " " << Util::getBlockName(iTerm) 
			<< "(" << sizesData[j] << "):" << std::endl;*/
		    double q = -DBL_MAX;
		    int index = -1;
		    oaString size;
		    for(int k=0; k<fanoutsData.size(); k++){	// for each fanout solution
			DPData *otherDP = fanoutsData[k];
			double load = fanoutsData[k]->inCap + outPin->netLoad;
			//double cellDelay2 = Util::getCellDelayEstimate(iTerm,sizesData[j],load,timing);
			    SubTimer sTimer(design,timing,
				    iTerm->getInst(),sizesData[j]);
			    sTimer.setLoad(load);
			    double cellDelay = sTimer.getCellDelayEstimate(iTerm);
			double tmp = otherDP->rAT-cellDelay;
			/*std::cout << "   q:" << tmp 
			    << " rat:" << otherDP->rAT 
			    << " cellDelay:" << cellDelay << "/" << cellDelay2
			    << " load:" << load << std::endl;*/
			//printMap(fanoutsData[k]->faninMap);
			if(otherDP->rAT - cellDelay > q){
			    q = otherDP->rAT-cellDelay;
			    index = k;
			}
		    }
		    if(iterRefine && cell->isMultiFanin){
			if(sizesData[j] != cell->master->name) continue;
		    }
		    DPData *currDP = new DPData(); 
		    currDP->rAT = q;
		    currDP->cellSize = sizesData[j];
		    currDP->faninMap = fanoutsData[index]->fanoutMap;
		    currDP->inCap = Util::getCellInputCap(iTerm,sizesData[j],timing);
		    currPin->pinDPData.push_back(currDP);
		}
		pruneSolutions(currPin->pinDPData);
	    }
	}
    }
    //DEBUG: Print Circuit Graph Solutions so far
}
/*---------------------------------------------------------*/
void
DP::DpRestoration(){
#if defined(DEBUG1)
    std::cout << "DpRestoration()" << std::endl;
#endif
    //printDPGraph();
    Util ut;
    dpSolutions.clear();
    //for each gate in topological order
    G = DesignTool::getTopological(design,timing); 
    for(int i=0; i<G.size(); i++){
	//std::cout << Util::getInstName(G[i]) << std::endl;
	CellData *cell = CellData::get(G[i]);
	assert(cell);

	oaString solution = getSolution(cell);
	if(solution.isEmpty()){
	    solution = resolveInconsistency(cell);
	}
	//save solution
	if(!solution.isEmpty()){
	    cell->swap(solution);
	    ut.invalidateFanIOTiming(design,timing,cell->inst);
	    timing->updateAll();
	    double worstArr = timing->getWorstArr();	
	    if(worstArr > targetDelay){
		cell->reverseSwap();
		ut.invalidateFanIOTiming(design,timing,cell->inst);
		timing->updateAll();
	    }else{
		cell->commitSwap();
	    }
	    dpSolutions[cell->occInst] = solution;
	}else{
	    dpSolutions[cell->occInst] = cell->master->name;
	}

	//save arr and forward solution
	oaOccInstTerm *outTerm = DesignTool::getOccOutInstTerm(cell->occInst);
	TPoint *outPin = TPoint::get(outTerm);
	assert(outPin);

	double maxArr = -DBL_MAX;
	oaIter<oaOccInstTerm> itIter = cell->occInst->getInstTerms();
	while(oaOccInstTerm *iTerm = itIter.getNext()){
	    TPoint *tp = TPoint::get(iTerm);
	    assert(tp);
	    if(tp->type == TIMING_POINT_SIGNAL_IN){
		if(tp->dpIndex == -1){ 
		    //tp->dpArr = getMaxArr(iTerm,solution);
		    tp->dpArr = timing->getArr(iTerm);
		    continue;
		}
		//tp->dpArr = tp->pinDPData[tp->dpIndex]->arr;
		tp->dpArr = timing->getArr(iTerm);
		map<oaOccInstTerm*,oaString>::iterator mapIter;
		map<oaOccInstTerm*,oaString> fwdMap 
		    = tp->pinDPData[tp->dpIndex]->faninMap;
		for(mapIter =fwdMap.begin() ; mapIter!=fwdMap.end(); mapIter++){
		    map<oaOccInstTerm*,oaString>::iterator tmpIter;
		    tmpIter = outPin->DPSolutions.find(mapIter->first);
		    if(tmpIter == outPin->DPSolutions.end()){
			maxArr = tp->pinDPData[tp->dpIndex]->arr;
			outPin->DPSolutions[mapIter->first] = mapIter->second; 
		    }else{
			if(tp->pinDPData[tp->dpIndex]->arr > maxArr){
			    maxArr = tp->pinDPData[tp->dpIndex]->arr;
			    outPin->DPSolutions[mapIter->first] = mapIter->second; 
			}
		    }
		}
	    }
	}
    }
    //Print Solutions
    /*std::cout << "Solutions:" << std::endl;
    map<oaOccInst*,oaString>::iterator it;
    for(it=dpSolutions.begin(); it!=dpSolutions.end(); ++it){
	CellData *cell = CellData::get(it->first->getModInst());
	assert(cell);
	std::cout << cell->instName << "(curr:" << cell->master->name << ")" 
	    << "->" << it->second << std::endl;
    }*/
}
/*---------------------------------------------------------*/
oaString
DP::getSolution(CellData *c){
#if defined(DEBUG1)
    std::cout << "getSolution(" << c->instName << ")" << std::endl;
#endif
    oaString size = oaString();
    bool flag = false;
    oaIter<oaOccInstTerm> itIter = c->occInst->getInstTerms();
    while(oaOccInstTerm *iTerm = itIter.getNext()){
	TPoint *tp = TPoint::get(iTerm);
	assert(tp);
	if(tp->type == TIMING_POINT_SIGNAL_IN){
	    oaString currSize;
	    if(tp->isFromPI || tp->isFromFF){
		double maxSlack = -DBL_MAX;
		for(int i=0; i<tp->pinDPData.size(); i++){
		    double q = tp->pinDPData[i]->rAT;
		    tp->pinDPData[i]->arr = timing->getArr(iTerm);
		    double slack = q - tp->pinDPData[i]->arr;
		    if( slack > maxSlack){
			maxSlack = slack;
			currSize = tp->pinDPData[i]->cellSize;
			tp->dpIndex = i;
			//std::cout << currSize << " indx:" << i << std::endl;
		    }
		}
	    }else{
		oaOccNet *net = iTerm->getNet();
		//If input arc is coming from an output arc of another cell
		oaIter<oaOccInstTerm> iter = net->getInstTerms();
		while(oaOccInstTerm *j = iter.getNext()){
		    TPoint *t = TPoint::get(j);
		    assert(t);
		    if(t->type == TIMING_POINT_SIGNAL_OUT){	
			oaString other = t->DPSolutions[iTerm];
			if(other.isEmpty()) flag = true;
			else currSize = other;
		    }
		}
	    }
	     
	    if(size.isEmpty()) size = currSize;
	    else if(size != currSize){ 
		flag = true;
	    }
	    
	}
    }
    if(flag) return oaString();
    //std::cout << " No Inconsistency - sol:" << size << std::endl;
    return size;
}
/*---------------------------------------------------------*/
oaString
DP::resolveInconsistency(CellData *c){
#if defined(DEBUG1)
    std::cout << "resolveInconsistency(" << c->instName << ")" << std::endl;
#endif
    oaString size;
    double maxSlack = -DBL_MAX;
    vector<oaString> sizesData = c->getAllSizes(); 
    for(int i=0; i<sizesData.size(); i++){	 //for all size options
	//std::cout << " Size:" << sizesData[i] << std::endl;
	double maxArr = -DBL_MAX;
	oaOccInstTerm *critPin;
	oaIter<oaOccInstTerm> itIter = c->occInst->getInstTerms();
	while(oaOccInstTerm *iTerm = itIter.getNext()){
	    TPoint *tp = TPoint::get(iTerm);
	    assert(tp);
	    if(tp->type == TIMING_POINT_SIGNAL_IN){
		double arr = 0.0;
		if(tp->isFromPI || tp->isFromFF)
		    arr = timing->getArr(iTerm);
		else
		    arr = getMaxArr(iTerm,sizesData[i]);
		//std::cout << " " << Util::getBlockName(iTerm) << " arr:" << arr << std::endl;
		if(arr > maxArr){
		    maxArr = arr;
		    critPin = iTerm;
		}
	    }
	}
	TPoint *p = TPoint::get(critPin);
	assert(p);
	for(int j=0; j<p->pinDPData.size(); j++){
	    if(sizesData[i] != p->pinDPData[j]->cellSize) continue;
	    double q = p->pinDPData[j]->rAT;
	    if( (q-maxArr) > maxSlack){
		maxSlack = q-maxArr;
		size = p->pinDPData[j]->cellSize;
		p->dpIndex = j;
		//std::cout << " taken " << std::endl;
	    }
	    //std::cout << " Critical Pin:" << Util::getBlockName(critPin) 
		//<< " with:" << size << " slack:" << maxSlack << std::endl;
	}
    }
    //std::cout << " exit resolveInconsistency(" << c->instName << ")" << std::endl;
    return size;
}
/*---------------------------------------------------------*/
double
DP::getMaxArr(oaOccInstTerm *in, oaString prospSize){
#if defined(DEBUG1)
    std::cout << "getMaxArr(" << Util::getBlockName(in) << "," << prospSize << ")" << std::endl;
#endif
    double maxArr = -DBL_MAX;
    CellData *cell = CellData::get(in->getInst()->getModInst());
    assert(cell); 
    oaString currFanoutSize = cell->master->name;
    TPoint *inPin = TPoint::get(in);
    assert(inPin);
    double wireDelay = inPin->netDelay;
    oaOccNet *net = in->getNet();
    oaIter<oaOccInstTerm> itIter1 = net->getInstTerms();
    while(oaOccInstTerm *i = itIter1.getNext()){
	TPoint *op = TPoint::get(i);
	assert(op);
	if(op->type == TIMING_POINT_SIGNAL_OUT){ //the output term to this input term
	    oaIter<oaOccInstTerm> itIter2 = i->getInst()->getInstTerms();
	    while(oaOccInstTerm *j = itIter2.getNext()){
		TPoint *ip = TPoint::get(j);
		assert(ip);
		if(ip->type == TIMING_POINT_SIGNAL_IN){ //the input term of the fanin cell to in
		    oaString dpSolSize = dpSolutions[j->getInst()];
		    double currFanoutLoad = Util::getCellInputCap(in,currFanoutSize,timing);
		    double prospFanoutLoad = Util::getCellInputCap(in,prospSize,timing);
		    double load = op->load - currFanoutLoad + prospFanoutLoad; 
		    //double delay = Util::getCellDelayEstimate(j,dpSolSize,load,timing);
			SubTimer sTimer(design,timing,
				j->getInst(),dpSolSize);
			sTimer.setLoad(load);
			double delay = sTimer.getCellDelayEstimate(j);
		    double arr = ip->dpArr + delay + wireDelay;
		    //std::cout << " arr:" << arr << "=" << ip->dpArr
			//<< "+" << delay << "+" << wireDelay << std::endl;
		    if(arr > maxArr) maxArr = arr;
		}
	    }
	}
    }
    //std::cout << " exit getMaxArr(" << Util::getBlockName(in) << "," << prospSize << ")" << std::endl;
    return maxArr;
}
/*---------------------------------------------------------*/
void
DP::copyDPData(DPData *src, DPData *dst){
    dst->cellSize = src->cellSize;
    dst->inCap = src->inCap;
    dst->rAT = src->rAT;
    dst->faninMap = src->faninMap;
}
/*---------------------------------------------------------*/
void
DP::copyVecData(vector<DPData*> &src, vector<DPData*> &dst){
#if defined(DEBUG) 
    std::cout << "copyVecData(" << src.size() << "," << dst.size() << ")" << std::endl;
#endif
    for(int i=0; i<src.size(); i++){
	DPData *d = new DPData;
	//d->cellSize = src[i]->cellSize;
	d->inCap = src[i]->inCap;
	d->rAT = src[i]->rAT;
	map<oaOccInstTerm*,oaString>::iterator it;
	for(it=src[i]->fanoutMap.begin(); it!=src[i]->fanoutMap.end(); ++it){
	    oaOccInstTerm *iTerm = it->first;
	    d->fanoutMap[iTerm] = it->second;
	}
	dst.push_back(d);
    }
}
/*---------------------------------------------------------*/
void 
DP::mergeFanoutSolutions(oaOccInstTerm *outTerm){
#if defined(DEBUG)
    std::cout << "mergeFanoutSolutions(" << Util::getBlockName(outTerm) << ")" << std::endl;
#endif
    TPoint *outPin = TPoint::get(outTerm);
    assert(outPin);
    outPin->pinDPData.clear();
    oaOccNet *net = outTerm->getNet();
    oaIter<oaOccTerm> tIter = net->getTerms();
    while(oaOccTerm *term = tIter.getNext()){
	TPoint *tp = TPoint::get(term);
	assert(tp);
	if(tp->type == TIMING_POINT_PO){
	    DPData *dp = new DPData;
	    dp->inCap = outPin->netLoad;
	    dp->rAT = targetDelay-tp->netDelay;
	    dp->fanoutMap.clear();
	    outPin->pinDPData.push_back(dp);
	}
    }
    oaIter<oaOccInstTerm> itIter = net->getInstTerms();
    while(oaOccInstTerm *other = itIter.getNext()){
	TPoint *otherTP = TPoint::get(other);
	assert(otherTP);
	if(otherTP->type == TIMING_POINT_SIGNAL_IN){
	    //handle seq ckt
	    CellData *cell = CellData::get(other->getInst()->getModInst());
	    assert(cell);
	    //std::cout << cell->instName << std::endl;
	    /*if(cell->master->isSequential){
		DPData *ld;
		ld->inCap = Util::getCellInputCap(other,cell->master->name,timing);
		ld->rAT = //min(d->rAT, (currDPVec[i]->rAT - tp->netDelay));
		ld.fanoutMap.clear();
		outPin->pinDPData.push_back(ld);
		continue;
	    }*/
	    if(outPin->pinDPData.empty()){
		if(cell->master->isSequential){
		    DPData *ld = new DPData;
		    ld->inCap = Util::getCellInputCap(other,cell->master->name,timing);
		    ld->rAT = timing->getReq(other) - otherTP->netDelay;
		    ld->fanoutMap.clear();
		    outPin->pinDPData.push_back(ld);
		    continue;
		}
		map<oaOccInstTerm*,oaString> sizeMap;
		for(int i=0; i<otherTP->pinDPData.size(); i++){
		    otherTP->pinDPData[i]->fanoutMap[other] 
			= otherTP->pinDPData[i]->cellSize;
		}
		copyVecData(otherTP->pinDPData,outPin->pinDPData);
		for(int i=0; i<otherTP->pinDPData.size(); i++){
		    otherTP->pinDPData[i]->fanoutMap.clear();
		}
	    }else{
		vector<DPData*> tmpVec;
		for(int i=0; i<outPin->pinDPData.size(); i++){
		    if(cell->master->isSequential){
			DPData *ld = new DPData;
			ld->inCap = Util::getCellInputCap(other,cell->master->name,timing);
			ld->rAT = min(outPin->pinDPData[i]->rAT,timing->getReq(other) - otherTP->netDelay);
			//copy other instTerm and its corresponding size
			map<oaOccInstTerm*,oaString>::iterator iter;
			for(iter=outPin->pinDPData[i]->fanoutMap.begin();
				iter!=outPin->pinDPData[i]->fanoutMap.end();
				++iter){
			    oaOccInstTerm *otherInstTerm = iter->first;
			    ld->fanoutMap[otherInstTerm] = iter->second; 
			}
			tmpVec.push_back(ld);
		    }else{
			for(int j=0; j<otherTP->pinDPData.size(); j++){
			    DPData *ld = new DPData;
			    ld->inCap = outPin->pinDPData[i]->inCap 
				+ otherTP->pinDPData[j]->inCap;
			    ld->rAT= min(outPin->pinDPData[i]->rAT
				    ,otherTP->pinDPData[j]->rAT);
			    ld->fanoutMap[other] = otherTP->pinDPData[j]->cellSize; 
			    //copy other instTerm and its corresponding size
			    map<oaOccInstTerm*,oaString>::iterator iter;
			    for(iter=outPin->pinDPData[i]->fanoutMap.begin();
				    iter!=outPin->pinDPData[i]->fanoutMap.end();
				    ++iter){
				oaOccInstTerm *otherInstTerm = iter->first;
				ld->fanoutMap[otherInstTerm] = iter->second; 
			    }
			    tmpVec.push_back(ld);
			}
		    }
		}
		clearDPDataVec(outPin->pinDPData);
		copyVecData(tmpVec,outPin->pinDPData);
		clearDPDataVec(tmpVec);
		/*std::cout << " Check outPin Vector " << std::endl;
		for(int i=0; i<outPin->pinDPData.size(); i++){
		    std::cout << " inCap:" << outPin->pinDPData[i]->inCap
			<< "/" << outPin->pinDPData[i]->rAT << std::endl;
		    map<oaOccInstTerm*,oaString>::iterator iter;
		    for(iter=outPin->pinDPData[i]->fanoutMap.begin();
			    iter!=outPin->pinDPData[i]->fanoutMap.end(); ++iter){
			std::cout << " " << Util::getBlockName(iter->first)
			    << "(" << iter->second << ")"; 
		    }
		    std::cout << std::endl;
		}*/
	    }
	    pruneSolutions(outPin->pinDPData);
	}
    }
}
/*---------------------------------------------------------*/
void 
DP::pruneSolutions(vector<DPData*> &d){
#if defined(DEBUG)
    std::cout << "pruneSolutions()" << std::endl;
#endif
    //DEBUG: Check pruned solutions
    /*std::cout << " *Before pruning - List Size " << d.size() << ":" << std::endl;
    for(int i=0; i<d.size(); i++){
	std::cout << " " << d[i]->cellSize << " (inCap:" << d[i]->inCap
	    << ",q:" << d[i]->rAT << ")" << std::endl;  
	map<oaOccInstTerm*,oaString> m = d[i]->faninMap;
	map<oaOccInstTerm*,oaString>::iterator iter;;
	for(iter=m.begin(); iter!=m.end(); iter++){
	    std::cout << " " << Util::getBlockName(iter->first)
		<< ":" << iter->second << std::endl;
	}
    }*/
    if(d.empty()) return;
    vector<DPData*>::iterator curr, next;
    curr = d.begin();
    next = curr+1;
    while(curr != d.end()){
	while(next != d.end()){
	    if((*curr)->inCap >= (*next)->inCap){ 
		if((*curr)->rAT <= (*next)->rAT){
		    clearDPData(*curr);
		    curr = d.erase(curr);
		    if(curr != d.end()) next = curr+1;
		    continue;
		}
	    }else{
		if((*curr)->rAT >= (*next)->rAT){
		    clearDPData(*next);
		    next = d.erase(next);
		    continue;
		}
	    }
	    next++;
	}
	curr++;
	if(curr != d.end()) next = curr+1;
    }
    //DEBUG: Check pruned solutions
    /*std::cout << " * After Pruning - List Size " << d.size() << ":" << std::endl;
    for(int i=0; i<d.size(); i++){
	std::cout << "  " << d[i]->cellSize << " (inCap:" << d[i]->inCap
	    << ",q:" << d[i]->rAT << ")" << std::endl;  
	map<oaOccInstTerm*,oaString> m = d[i]->faninMap;
	map<oaOccInstTerm*,oaString>::iterator iter;;
	for(iter=m.begin(); iter!=m.end(); iter++){
	    std::cout << "  " << Util::getBlockName(iter->first)
		<< ":" << iter->second << std::endl;
	}
    }*/
}
/*---------------------------------------------------------*/
void
DP::clearDPDataVec(vector<DPData*> &vec){
#if defined(DEBUGFree)
    std::cout << "clearDPDataVec" << std::endl;
#endif
    for(int i=0; i<vec.size(); i++){
	clearDPData(vec[i]);
    }
    vec.clear();
}
/*---------------------------------------------------------*/
void
DP::clearDPData(DPData *v){
#if defined(DEBUGFree)
    std::cout << " clearDPData" << std::endl;
#endif
    v->fanoutMap.clear();
    delete v;
}
/*---------------------------------------------------------*/
void
DP::printMap(map<oaOccInstTerm*,oaString> m){
    map<oaOccInstTerm*,oaString>::iterator iter;
    std::cout << "   OutputFanin:" << std::endl;
    for(iter=m.begin(); iter!=m.end(); ++iter){
	std::cout << "    " << Util::getBlockName(iter->first)
	    << "->" << iter->second << std::endl;
    }
}
void
DP::printDPData(vector<DPData*> d){
    for(int i=0; i<d.size(); i++){
	std::cout << " cell:" << d[i]->cellSize 
	    << ":" << d[i]->inCap << ":" << d[i]->rAT << std::endl;
    }
}
/*---------------------------------------------------------*/
void
DP::printDPGraph(){
    for(int i=0; i<G.size(); i++){
	std::cout << Util::getInstName(G[i]) << std::endl;
	CellData *cell = CellData::get(G[i]);
	assert(cell);
	//oaOccInstTerm *instTerm = DesignTool::getOccOutInstTerm(cell->occInst);
	//TPoint *outPin = TPoint::get(instTerm);
	//assert(outPin);
	/*std::cout << "OutPin:" << Util::getBlockName(instTerm) 
	    << " netLoad:" << outPin->netLoad << std::endl;*/
	//vector<DPData*> fanoutsData = outPin->pinDPData;
	 
	oaIter<oaOccInstTerm> itTerm = cell->occInst->getInstTerms();
	while(oaOccInstTerm *iTerm = itTerm.getNext()){
	    TPoint *currPin = TPoint::get(iTerm);
	    assert(currPin);
	    //if(currPin->type == TIMING_POINT_SIGNAL_IN){
		vector<DPData*> currPinData = currPin->pinDPData;
		std::cout << " " << Util::getBlockName(iTerm)
		    << "(curr:" << cell->master->name << ")" << std::endl;
		for(int j=0; j<currPinData.size(); j++){
		    std::cout << "  " << currPinData[j]->cellSize
			<< "[c:" << currPinData[j]->inCap 
			<< ",q:" << currPinData[j]->rAT << "] based on:" << std::endl;
		    printMap(currPinData[j]->faninMap);
		}
	    //}
	}
    }
}
/*---------------------------------------------------------*/
/*void 
DP::mergeFanoutSolutions(oaOccInstTerm *outPin){
#if defined(DEBUG)
    std::cout << "mergeFanoutSolutions(" << Util::getBlockName(outPin) << ")" << std::endl;
#endif
    //Need to take care FF case
    oaOccNet *net = outPin->getNet();
    DPData *dp = new DPData;
    dp->faninMap.clear();
    dp->inCap = 0.0;
    dp->rAT = DBL_MAX;
    oaIter<oaOccTerm> tIter = net->getTerms();
    while(oaOccTerm *term = tIter.getNext()){
	TPoint *tp = TPoint::get(term);
	assert(tp);
	if(tp->type == TIMING_POINT_PO){
	    dp->rAT = timing->getPeriod()-tp->netDelay;
	}
    }
    count = 0;
    oaIter<oaOccInstTerm> itIter = net->getInstTerms();
    merge(outPin, itIter, dp);
    delete dp;

    //DEBUG
#if defined(DEBUG)
    std::cout << "**DEBUG:" << Util::getBlockName(outPin) << std::endl;
    TPoint *tp = TPoint::get(outPin);
    assert(tp);
    vector<DPData*> vec = tp->pinDPData;
    for(int i=0; i<vec.size(); i++){
	map<oaOccInstTerm*,oaString> m = vec[i]->faninMap;
	map<oaOccInstTerm*,oaString>::iterator iter;;
	for(iter=m.begin(); iter!=m.end(); iter++){
	    std::cout << " " << Util::getBlockName(iter->first)
		<< ":" << iter->second << std::endl;
	}
	std::cout << "  (inCap:" << vec[i]->inCap
	    << ",q:" << vec[i]->rAT << std::endl;  
    }
#endif
}*/
/*---------------------------------------------------------*/
/*void
DP::merge(oaOccInstTerm *outPin, oaIter<oaOccInstTerm> itIter, DPData *d){
#if defined(DEBUG)
    std::cout << "merge()" << std::endl;
#endif
    if(oaOccInstTerm *iTerm = itIter.getNext()){
	TPoint *tp = TPoint::get(iTerm);
	assert(tp);
	//std::cout << "merge(" << Util::getBlockName(iTerm) << ")" << std::endl;
	if(tp->type == TIMING_POINT_SIGNAL_IN){
	    vector<DPData*> currDPVec = tp->pinDPData;
	    for(int i=0; i<currDPVec.size(); i++){
		double tempRAT = d->rAT;
		d->faninMap[iTerm] = currDPVec[i]->cellSize;
		d->inCap += currDPVec[i]->inCap;
		d->rAT = min(d->rAT, (currDPVec[i]->rAT - tp->netDelay));
		merge(outPin, itIter, d);
		
		//Clear previous data before merging next combination
		d->faninMap.erase(iTerm);
		d->inCap -= currDPVec[i]->inCap;
		d->rAT = tempRAT;
	    }
	}else{
	    merge(outPin, itIter, d);
	}
    }else{
	DPData *dCopy = new DPData;
	copyDPData(d,dCopy);
	TPoint *tp = TPoint::get(outPin);
	assert(tp);
	tp->pinDPData.push_back(dCopy);
	pruneSolutions(tp->pinDPData);
    }
}*/

/*---------------------------------------------------------*/
}//namespace
