/************************************************************
* 
* File: oagTimerCellMaster.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 05-13-2010
* Last Modified: Sun 20 Mar 2011 05:44:41 PM PDT
*
************************************************************/
#include <assert.h>
#include <iostream>

#include "oaDesignDB.h"
#include "oagTimerCellMaster.h"


namespace oagTimer{

using namespace std;
using namespace oa;
/*---------------------------------------------------------*/
oaVoidPointerAppDef<oaModule> *CellMaster::_modAppDef = 0;
/*---------------------------------------------------------*/
void
CellMaster::initAppDefs()
{
    assert(!_modAppDef);
    _modAppDef = oaVoidPointerAppDef<oaModule>::get("oagTimerMasterMod");
    assert(_modAppDef);
}
/*---------------------------------------------------------*/
CellMaster *
CellMaster::create(oaModule *mod)
{
    assert(mod);
    assert(!_modAppDef->get(mod));
    CellMaster *cm = new CellMaster();
    _modAppDef->set(mod, static_cast<void *>(cm));
    return cm;
}
/*---------------------------------------------------------*/
CellMaster *
CellMaster::get(oaModule *mod)
{
    assert(mod);
    CellMaster *cm = static_cast<CellMaster *>
        (_modAppDef->get(mod));
    return cm;
}
/*---------------------------------------------------------*/
void
CellMaster::setLibCellName(const char *s){
    name = s;
    Util::parseLibCellName(name,basename,strength);
}
/*---------------------------------------------------------*/
// DEBUG
/*---------------------------------------------------------*/
void
CellMaster::printCellData(){
    std::cout << "CellMaster:" << name << std::endl;
    std::cout << " base:" << basename << std::endl;
    std::cout << " drive_strength:" << strength << std::endl;
    std::cout << " area:" << area << std::endl;
    std::cout << " leakage:" << leakage_power << std::endl;
    std::cout << std::endl;
}
/*---------------------------------------------------------*/
}
