/************************************************************
* 
* File: oagTimerCellData.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 05-18-2010
* Last Modified: Sun 06 Mar 2011 05:19:18 PM PST
*
************************************************************/
#include <assert.h>
#include "oagTimerCellData.h"

#include "oagTimerDesignTool.h"

//#define DEBUG
#define MODE_READ 'r'
/*---------------------------------------------------------*/
using namespace std;
using namespace oa;

namespace oagTimer {
/*---------------------------------------------------------*/
void
CellData::initSizing(sizingSignal s){
#if defined(DEBUG)
    std::cout << "CD::initSizing()" << std::endl;
#endif
    if(!valid) assert(0);
    _signal = s;
    if(cell_sizes.empty()) addOtherSizes();
    int count = 0;
    for(Lib_list::iterator it=cell_sizes.begin();
	    it!=cell_sizes.end(); ++it){
	++count;
	if(*it == master->name){ 
	    lib_this_ptr = lib_seek_ptr = it;
	    dnCount = count-1;
	    if(dnCount > 0) lib_seek_ptr = --it;
	    upCount = (int)cell_sizes.size()-count;
	    if(upCount > 0) lib_seek_ptr = ++it;
	    break;
	}
    }
    /*std::cout << " " << instName << ":" << master->name 
	<< " " << dnCount << " - " << upCount << std::endl;*/
    lib_temp_ptr = cell_sizes.end();
    //resetLibListPtr();
}
/*---------------------------------------------------------*/
void
CellData::addOtherSizes(){
#if defined(DEBUG)
    std::cout << "CD::addOtherSizes()" << std::endl;
#endif
    if(!valid) assert(0);
    if(!cell_sizes.empty())
	cell_sizes.clear();
    for(libDataVector::iterator iter = libParseData.libCellNames.begin();
	    iter!=libParseData.libCellNames.end(); ++iter){
	oaString otherCellBasename;
	double otherSize;
	Util::parseLibCellName(*iter,otherCellBasename,otherSize);
        if(otherCellBasename == master->basename){
	    cell_sizes.push_back(*iter);
	}
    }
    cell_sizes.sort(CellData::increasing_strengths);
}
/*---------------------------------------------------------*/
oaString
CellData::getNextSize(){
#if defined(DEBUG)
    std::cout << "CD::getNextSize()" << std::endl;
#endif
    if(!valid) assert(0);
    if(cell_sizes.empty()){ 
	std::cout << "EMPTY:getNextSize()" << std::endl;
	addOtherSizes();
    }
    oaString str;
    //oaString str = *lib_seek_ptr;
    lib_temp_ptr = lib_seek_ptr;
    switch(_signal){
	case DOWN_SIZE:
	    str = *lib_seek_ptr;
	    break;
	case UP_SIZE:
	    str = *lib_seek_ptr;
	    break;
	case ALL_SIZE:
	    str = *lib_seek_ptr;
	    break;
	default:
	    return oaString();
    }
    updateLibSeekPtr();
    return str;
}
/*---------------------------------------------------------*/
void 
CellData::updateLibSeekPtr(){
#if defined(DEBUG)
    std::cout << "CD::updateLibSeekPtr()" << std::endl;
#endif
    if(!valid) assert(0);
    Lib_list::iterator curr_temp_iter = lib_this_ptr;
    switch(_signal){
	case DOWN_SIZE:
	    if(lib_seek_ptr == cell_sizes.begin()){
		//Restricting DOWN SIZE ONLY
		lib_seek_ptr = lib_this_ptr;
		//Unrestricted (try all);
		//lib_seek_ptr = --cell_sizes.end();
	    }else --lib_seek_ptr;
	    return;
	case UP_SIZE:
	    if(lib_seek_ptr == --cell_sizes.end()){
		//Restricting UP SIZE ONLY
		lib_seek_ptr = lib_this_ptr;
		//Unrestricted (try all);
		//lib_seek_ptr = cell_sizes.begin();
	    }else ++lib_seek_ptr;
	    return;
	case ALL_SIZE:
	    if(lib_seek_ptr == cell_sizes.begin()){
		lib_seek_ptr = --cell_sizes.end();
	    }else if(lib_seek_ptr == cell_sizes.end()){
		lib_seek_ptr = cell_sizes.begin();
	    }else{
		--lib_seek_ptr;
	    }
	    return;
    }
}
/*---------------------------------------------------------*/
bool
CellData::hasMoreSize(){
#if defined(DEBUG)
    std::cout << "hasMoreSize()" << std::endl;
#endif
    if(!valid) assert(0);
    //Lib_list::iterator curr_temp_iter = lib_this_ptr;
    /*switch(_signal){
	case CURRENT_SIZE:
	case DOWN_SIZE:
	    //std::cout << "DOWN_SIZE" << std::endl;
	    if(lib_this_ptr == cell_sizes.begin()) return false;
	    else if(lib_seek_ptr == curr_temp_iter){
		return false;
	    }
	    break;
	case UP_SIZE:
	    //std::cout << "UP_SIZE" << std::endl;
	    if(lib_this_ptr == --cell_sizes.end()) return false;
	    else if(lib_seek_ptr == curr_temp_iter){
		return false;
	    }
	    break;
	case ALL_SIZE:
	    //std::cout << "ALL_SIZE" << std::endl;
	    if((int)cell_sizes.size() == 1) return false;
	    else if(lib_seek_ptr == curr_temp_iter) return false;
	    break;
	case NULL_SIZE:
	default:
	    return false;
    }*/
    if(lib_seek_ptr == lib_this_ptr) return false;
    return true;
}
/*---------------------------------------------------------*/
bool
CellData::isMaxSize(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) initSizing(_signal);
    if(lib_this_ptr == --cell_sizes.end()) return true;
    return false;
}
/*---------------------------------------------------------*/
bool
CellData::isMinSize(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) initSizing(_signal);
    if(lib_this_ptr == cell_sizes.begin()) return true;
    return false;
}
/*---------------------------------------------------------*/
void
CellData::resetLibListPtr(){
#if defined(DEBUG)
    std::cout << "CellData::resetLibListPtr(" << *lib_this_ptr << 
	")" << std::endl;
#endif
    if(!valid) assert(0);
    //Lib_list::iterator curr_temp_iter = lib_this_ptr;
    lib_seek_ptr = lib_this_ptr;
    /*
    switch(_signal){
	case CURRENT_SIZE:
	    lib_seek_ptr = lib_this_ptr;
	    break;
	case DOWN_SIZE:
	    lib_seek_ptr = cell_sizes.begin(); 
	    break;
	case UP_SIZE:
	    lib_seek_ptr = --cell_sizes.end();
	    break;
	case ALL_SIZE:
	    if(curr_temp_iter == --cell_sizes.end())
		lib_seek_ptr = cell_sizes.begin();
	    else if(curr_temp_iter == cell_sizes.begin())
		lib_seek_ptr = --cell_sizes.end();
	    else
		lib_seek_ptr = ++curr_temp_iter;
	
	    break;
	case NULL_SIZE:
	default:
	    lib_seek_ptr = cell_sizes.end();
	    break;
    }
    */
}
/*---------------------------------------------------------*/
vector<oaString>
CellData::getAllSizes(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) addOtherSizes();
    vector<oaString> libSizes;
    Lib_list::iterator it;
    for(it=cell_sizes.begin(); it!=cell_sizes.end(); ++it){
	//std::cout << " "<< *it << std::endl;
	libSizes.push_back(*it);
    }
    return libSizes;
}
/*---------------------------------------------------------*/
vector<oaString>
CellData::getOtherSizes(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) addOtherSizes();
    vector<oaString> libSizes;
    Lib_list::iterator it;
    for(it=cell_sizes.begin(); it!=cell_sizes.end(); ++it){
	if(*it == master->name) continue;
	libSizes.push_back(*it);
    }
    return libSizes;
}
/*---------------------------------------------------------*/
vector<oaString> 
CellData::getGreaterThanCurrentSize(){
    /*cout << "Querying Cell GREATER than current size ... " 
	<< *lib_this_ptr << endl;*/
    if(!valid) assert(0);
    vector<oaString> _vec;
    if(cell_sizes.empty()) return _vec;
    Lib_list::iterator temp_iter;
    temp_iter = lib_this_ptr;
    if(temp_iter == (--cell_sizes.end())) return _vec;
    while(++temp_iter != cell_sizes.end()){
	//std::cout << "  " << *temp_iter << std::endl;
	_vec.push_back(*temp_iter);
    }
    return _vec;
}
/*---------------------------------------------------------*/
vector<oaString> 
CellData::getLessThanCurrentSize(){
    /*cout << "Querying Cell LESS than current size ... "
	<< *lib_this_ptr << endl;*/
    if(!valid) assert(0);
    vector<oaString> _vec;
    if(cell_sizes.empty()) return _vec;
    Lib_list::iterator temp_iter;
    temp_iter = lib_this_ptr;
    if(temp_iter == cell_sizes.begin()) return _vec;
    do{
	--temp_iter;
	_vec.push_back(*temp_iter);
	//std::cout << "  " << *temp_iter << std::endl;
    }while(temp_iter != cell_sizes.begin());
    return _vec;
}
/*---------------------------------------------------------*/
oaString
CellData::getMinSize(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) addOtherSizes();
    return cell_sizes.front();
}
/*---------------------------------------------------------*/
oaString
CellData::getMaxSize(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) addOtherSizes();
    return cell_sizes.back();
}
/*---------------------------------------------------------*/
int
CellData::getDownSizeCount(){
    if(!valid) assert(0);
    /*if(cell_sizes.empty()) addOtherSizes();
    if((int)cell_sizes.size() == 1) return 0;*/
    return dnCount;
}
/*---------------------------------------------------------*/
int
CellData::getUpSizeCount(){
    if(!valid) assert(0);
    /*if(cell_sizes.empty()) addOtherSizes();
    if((int)cell_sizes.size() == 1) return 0;*/
    return upCount;
}
/*---------------------------------------------------------*/
int
CellData::getNumOfSizes(){
    if(!valid) assert(0);
    if(cell_sizes.empty()) addOtherSizes();
    return ((int)cell_sizes.size()-1);
}
/*---------------------------------------------------------*/
void 
CellData::swap(oaString cellName){
#if defined(DEBUG)
    std::cout << "CD::swap()" << std::endl;
#endif
    if(!valid) assert(0);
    oaNativeNS NS;
    const oaScalarName libertyName(NS, libParseData.libString);
    const oaScalarName libertyView(NS, libParseData.viewString);
    const oaScalarName libertyCell(NS, cellName);

    oaDesign *lib_cell = oaDesign::open(
	    libertyName, libertyCell, libertyView, MODE_READ);
    assert(lib_cell);
    oaModScalarInst* scalarInst = static_cast<oaModScalarInst*>(inst);
    assert(scalarInst);
    scalarInst->setMaster(lib_cell);
    assert(scalarInst);
    valid = false; 
    lib_cell->close();

    //Set flag to indicate that this gate has size change
    oaOccInstTerm *term = DesignTool::getOccOutInstTerm(occInst);
    TPoint *p = TPoint::get(term);
    assert(p);
    //p->swapFlag = true;
    p->delay1 = 0.0;
    p->delay2 = 0.0;
}
/*---------------------------------------------------------*/
void
CellData::reverseSwap(){
#if defined(DEBUG)
    std::cout << "CD::Reverese Swap()" << std::endl;
#endif
    oaNativeNS NS;
    const oaScalarName libertyName(NS, libParseData.libString);
    const oaScalarName libertyView(NS, libParseData.viewString);
    const oaScalarName libertyCell(NS, master->name);

    oaDesign *lib_cell = oaDesign::open(
	    libertyName, libertyCell, libertyView, MODE_READ);
    assert(lib_cell);
    oaModScalarInst* scalarInst = static_cast<oaModScalarInst*>(inst);
    assert(scalarInst);
    scalarInst->setMaster(lib_cell);
    assert(scalarInst);
    valid = true; 
    lib_cell->close();

    //Reset cell delay values
    oaOccInstTerm *term = DesignTool::getOccOutInstTerm(occInst);
    TPoint *p = TPoint::get(term);
    assert(p);
    p->delay1 = 0.0;
    p->delay2 = 0.0;
}
/*---------------------------------------------------------*/
void
CellData::commitSwap(){
    CellMaster *cm = CellMaster::get(inst->getMasterModule()); 
    assert(cm);
    master = cm;
    valid = true;
    cell_sizes.clear();
    initSizing(_signal);
    //updateLibSeekPtr();

    //UnSet flag to indicate that this gate has size change
    oaOccInstTerm *term = DesignTool::getOccOutInstTerm(occInst);
    TPoint *p = TPoint::get(term);
    assert(p);
    p->swapFlag = false;
}
/*---------------------------------------------------------*/
void
CellData::unsetSwapFlag(){
    if(!valid) assert(0);
    oaOccInstTerm *term = DesignTool::getOccOutInstTerm(occInst);
    TPoint *p = TPoint::get(term);
    assert(p);
    p->swapFlag = false;
}
/*---------------------------------------------------------*/
void
CellData::commitSwap(oaModInst* new_inst){
#if defined(DEBUG)
    std::cout << "CD::Commit Swap()" << std::endl;
#endif
    CellMaster *cm = CellMaster::get(new_inst->getMasterModule()); 
    assert(cm);
    master = cm;
    inst = new_inst;
    instName = Util::getInstName(new_inst);
    valid = true;
    initSizing(_signal);
    //updateLibSeekPtr();
}
/*---------------------------------------------------------*/
void
CellData::mark(oaModInstTerm *i){
    if(!valid) assert(0);
    map<oaModInstTerm*,int>::iterator iter;
    iter = inputTerms.find(i);
    if(iter!=inputTerms.end()){
	inputTerms[i] = 1;
    }
}
/*---------------------------------------------------------*/
bool
CellData::isAllInputMark(){
    for(map<oaModInstTerm*,int>::iterator it=inputTerms.begin();
	    it!=inputTerms.end(); ++it){
	if(it->second == 0) return false;
    }
    //Clean flags in case getTopological get call again
    for(map<oaModInstTerm*,int>::iterator it=inputTerms.begin();
	    it!=inputTerms.end(); ++it){
	it->second = 0;
    }
    return true;
}
/*---------------------------------------------------------*/
void
CellData::setForwardWeight(oaModInstTerm* iTerm, double val,double d){
    map<oaModInstTerm*,netData>::iterator iter;
    iter = inputTermsNetMap.find(iTerm);
    if(iter!=inputTermsNetMap.end()){
	inputTermsNetMap[iTerm].discount = d;
	inputTermsNetMap[iTerm].forward_weight = val;
    }
}
/*---------------------------------------------------------*/
void
CellData::setBackwardWeight(double val){
    map<oaModInstTerm*,netData>::iterator iter;
    for(iter=inputTermsNetMap.begin(); 
	    iter!= inputTermsNetMap.end(); ++iter){
	double d = iter->second.discount;
	double F = iter->second.forward_weight;
	double B = d*val;
	inputTermsNetMap[iter->first].backward_weight = B;
	inputTermsNetMap[iter->first].weight = F*B;
    }
}
/*---------------------------------------------------------*/
double
CellData::getBackwardWeight(oaModInstTerm* iTerm){
    map<oaModInstTerm*,netData>::iterator iter;
    iter = inputTermsNetMap.find(iTerm);
    if(iter!=inputTermsNetMap.end()){
	return inputTermsNetMap[iTerm].backward_weight;
    }
}
/*---------------------------------------------------------*/
double
CellData::getNetWeightSum(){
    if(inputTermsNetMap.empty()) return 0.0;

    double ws = 0.0;
    for(map<oaModInstTerm*,netData>::iterator it=inputTermsNetMap.begin();
	    it!=inputTermsNetMap.end(); ++it){
	ws += (it->second).forward_weight;
    }
    return ws;
}
/*---------------------------------------------------------*/
bool
CellData::isRootNode(){
    if(!valid) assert(0);
    return isRoot;
}
/*---------------------------------------------------------*/
bool
CellData::isFanoutNode(){
    if(!valid) assert(0);
    return isFanout;
}
/*---------------------------------------------------------*/
void
CellData::setRootNode(){
    if(!valid) assert(0);
    if(isFanout && isMark) return; 
    isFanout = false;
    isRoot = true;
}
/*---------------------------------------------------------*/
void
CellData::setFanoutNode(){
    if(!valid) assert(0);
    if(isRoot && isMark) return; 
    isRoot = false;
    isFanout = true;
}
/*---------------------------------------------------------*/
void
CellData::unsetNode(){
    isFanout = isMark = isRoot = false;
}
/*---------------------------------------------------------*/
bool
CellData::isDiffThanCurrSize(){
    if(!valid) assert(0);
    if(lib_this_ptr != lib_temp_ptr) return true;
    return false;
}
/*---------------------------------------------------------*/
bool
CellData::validFanoutSensitivity(double sensitivity,
	double delta){
    if(!valid) assert(0);
    //When fanout sensitivity value is still unknown
    if(fanoutSensitivity < 0) fanoutSensitivity = sensitivity;

    double currentSensitivity = delta*fanoutSensitivity;
    if(sensitivity < currentSensitivity) return false; 
    return true;
}
/*---------------------------------------------------------*/
void
CellData::setFanoutSensitivity(double sensitivity){
    if(!valid) assert(0);
    if(sensitivity > fanoutSensitivity) 
	fanoutSensitivity = sensitivity;
}
/*---------------------------------------------------------*/
/*! DEBUG FUNCTION */
/*---------------------------------------------------------*/
void
CellData::printTimingData(oaDesign* top, Timer* t){
    oaOccInst *occInst = DesignTool::getOccInst(top,inst);
    oaIter<oaOccInstTerm> itIter = occInst->getInstTerms();
    while(oaOccInstTerm *iTerm = itIter.getNext()){
	std::cout << "   " << t->getBlockName(iTerm)
	    << " Arr:" << t->getArr(iTerm) 
	    << " Slack:" << t->getSlack(iTerm) << std::endl;
    }
}
/*---------------------------------------------------------*/
oaVoidPointerAppDef<oaModInst> *CellData::_instAppDef = 0;
/*---------------------------------------------------------*/
void
CellData::initAppDefs(){
    assert(!_instAppDef);
    _instAppDef = oaVoidPointerAppDef<oaModInst>::get("oagTimerModInst");
    assert(_instAppDef);
}
/*---------------------------------------------------------*/
CellData *
CellData::create(oaOccInst *oci){
    assert(oci);
    oaModInst *inst = oci->getModInst();
    assert(inst);
    assert(!_instAppDef->get(inst));
    CellData *cd = new CellData();
    _instAppDef->set(inst, static_cast<void *>(cd));
    
    cd->occInst = oci;
    cd->inst = inst;
    cd->instName = Util::getInstName(inst);
    CellMaster *cm = CellMaster::get(inst->getMasterModule());
    assert(cm);
    cd->master = cm;
    oaIter<oaModInstTerm> instTermIter = inst->getInstTerms();
    while(oaModInstTerm* i = instTermIter.getNext()){
	oaTermType type(i->getTerm()->getTermType());
	if(type == oacInputTermType){
	    cd->inputTermsNetMap[i].net = i->getNet();
	    cd->inputTermsNetMap[i].discount = 0.0;
	    cd->inputTermsNetMap[i].forward_weight = 0.0;
	    cd->inputTermsNetMap[i].backward_weight = 0.0;
	    cd->inputTermsNetMap[i].weight = 0.0;
	    cd->inputTerms[i] = 0;
	}else if(type == oacOutputTermType){
	    cd->outputTerms[i] = 0;
	}
    }
    if(cd->inputTerms.size() > 1) cd->isMultiFanin = true;
    cd->valid = true;
    cd->initSizing(sizingSignal(ALL_SIZE));
    return cd;
}
/*---------------------------------------------------------*/
CellData *
CellData::get(oaModInst *inst){
    assert(inst);
    CellData *cd = static_cast<CellData *>
        (_instAppDef->get(inst));
    return cd;
}
/*---------------------------------------------------------*/
}//namespace
