#!/usr/bin/perl
#
# Compares two timing report files, each containing lines in the format:
#     <instance>/<pin> <load> <rslew> <fslew> <rslack> <fslack>
# or 
#     <port> <load> <rslew> <fslew> <rslack> <fslack>
#
# Usage: compare_loose.pl <file1> <file2>
#
# Author: Luis Guerra e Silva <lgs@algos.inesc-id.pt>
#

#
# tolerances
#
$captol = 0.11;
$slewtol = 0.11;
$slacktol = 0.81;
$coverage = 0.79;

#
# initializations
#
%names1 = ();
%names2 = ();
@cap1 = ();
@cap2 = ();
@rslew1 = ();
@rslew2 = ();
@fslew1 = ();
@fslew2 = ();
@rslack1 = ();
@rslack2 = ();
@fslack1 = ();
@fslack2 = ();
$nodecount1 = 0;
$nodecount2 = 0;

#
# function that compares two values, given a tolerance
#
sub compare {
    $val1 = $_[0];
    $val2 = $_[1];
    $tol = $_[2];
    if ($val1 == "infinity" || $val1 == "infinity" ||
        $val2 == "-infinity" || $val2 == "-infinity") {
        return !($val1 == $val2);
    }
    else {
        return (abs($val1-$val2)>abs($tol));
    }
}

#
# reads the first file
#
open( IN, "< $ARGV[0]" ) or die "Can't open $ARGV[0]";
$idx = 0;
while(<IN>) {
    chop;
    ($name, $cap, $rslew, $fslew, $rslack, $fslack) = split(/ /);
    $names1{$name} = $idx;
    $cap1[$idx] = $cap;
    $rslew1[$idx] = $rslew;
    $fslew1[$idx] = $fslew;
    $rslack1[$idx] = $rslack;
    $fslack1[$idx] = $fslack;
    $idx++;
}
close IN;
$nodecount1 = $idx;

#
# reads the second file
#
open( IN, "< $ARGV[1]" ) or die "Can't open $ARGV[1]";
$idx = 0;
while(<IN>) {
    chop;
    ($name, $cap, $rslew, $fslew, $rslack, $fslack) = split(/ /);
    $names2{$name} = $idx;
    $cap2[$idx] = $cap;
    $rslew2[$idx] = $rslew;
    $fslew2[$idx] = $fslew;
    $rslack2[$idx] = $rslack;
    $fslack2[$idx] = $fslack;
    $idx++;
}
close IN;
$nodecount2 = $idx;

#
# compare data
#
$matches = 0;
for my $key (keys(%names2)) {
    $idx1 = $names1{$key};
    $idx2 = $names2{$key};
    if ($idx1 == '') {
    }
    else {
       if (compare($cap1[$idx1], $cap2[$idx2], $captol)) {
           print "cap1($key)=$cap1[$idx1] differs from cap2($key)=$cap2[$idx2]\n";  
	   exit(1);
       }
       if (compare($rslew1[$idx1], $rslew2[$idx2], $slewtol)) {
           print "rslew1($key)=$rslew1[$idx1] differs from rslew2($key)=$rslew2[$idx2]\n";  
	   exit(1);
       }
       if (compare($fslew1[$idx1], $fslew2[$idx2], $slewtol)) {
           print "fslew1($key)=$fslew1[$idx1] differs from fslew2($key)=$fslew2[$idx2]\n";  
	   exit(1);
       }
       if (compare($rslack1[$idx1], $rslack2[$idx2], $slacktol)) {
           print "rslack1($key)=$rslack1[$idx1] differs from rslack2($key)=$rslack2[$idx2]\n";  
	   exit(1);
       }
       if (compare($fslack1[$idx1], $fslack2[$idx2], $slacktol)) {
           print "fslack1($key)=$fslack1[$idx1] differs from fslack2($key)=$fslack2[$idx2]\n";  
	   exit(1);
       }
       $matches++;
    }
}

#
# checks that a large enough number of entries has been matched
#
if ($nodecount1 > $nodecount2) {
    $maxcount = $nodecount1;
}
else {
    $maxcount = $nodecount2;
}
if ($matches < $coverage * $maxcount) {
    print "not enough number of matches: $matches / $maxcount\n";
    exit(1);
}

exit(0)
