#if !defined(oagSswCircuitSatSolver_P)
#define oagSswCircuitSatSolver_P

#include <climits>
#include "oaBase.h"
#include "Solver.h"

namespace oagSsw
{

using namespace oagMiniSat;

/// MiniSat solver with extensions for solving circuits.
class CircuitSatSolver : public Solver {
  public:
                            CircuitSatSolver() : Solver() {}

    /// \brief Find a satisfying assignment.
    ///
    /// \param maxConflicts the maximum number of conflicts allowed during the
    /// search
    /// \return l_True if a satisfying assignment is found.
    /// \return l_False if the clauses are unsatisfiable.
    /// \return l_Under if the max number of conflicts is reached.
    lbool                   solve(oa::oaUInt4       maxConflicts = UINT_MAX);
    /// \brief Find a satisfying assignment consistent with some assumptions.
    ///
    /// \param assumps literals that will be assumed to be true
    /// \param maxConflicts the maximum number of conflicts allowed during the
    /// search
    /// \return l_True if a satisfying assignment is found.
    /// \return l_False if the clauses are unsatisfiable.
    /// \return l_Under if the max number of conflicts is reached.
    lbool                   solve(const vec<Lit>    &assumps,
                                  oa::oaUInt4       maxConflicts = UINT_MAX);

    /// Helper functions for translating circuits to CNF.
    /// These functions add clauses to assert relations between their inputs(s)
    /// and output.
    //@{

    /// \param a input
    /// \param o output
    void                    addNotGate(const Lit    &a,
                                       const Lit    &o);
    /// \param a input
    /// \param b input
    /// \param o output
    void                    addAndGate(const Lit    &a,
                                       const Lit    &b,
                                       const Lit    &o);
    /// \param a input
    /// \param b input
    /// \param o output
    void                    addOrGate( const Lit    &a,
                                       const Lit    &b,
                                       const Lit    &o);
    /// \param a input
    /// \param b input
    /// \param o output
    void                    addXorGate(const Lit    &a,
                                       const Lit    &b,
                                       const Lit    &o);

    /// \param as inputs
    /// \param o output
    void                    addAndGate(const vec<Lit>   &as,
                                       const Lit        &o);
    /// \param as inputs
    /// \param o output
    void                    addOrGate(const vec<Lit>    &as,
                                      const Lit         &o);
    //@}
};

}

#endif

