#include "oagSswCircuitSatSolver.h"

#include <iostream>
#include <iomanip>

using namespace std;
using namespace oa;
using namespace oagMiniSat;

namespace oagSsw
{

lbool
CircuitSatSolver::solve(oa::oaUInt4 maxConflicts)
{
    vec<Lit> assumps;
    return solve(assumps, maxConflicts);
}
    
lbool
CircuitSatSolver::solve(const vec<Lit> &assumps,
                        oa::oaUInt4    maxConflicts)
{
    // This definition is copied from Solver.C with a few modifications.

    simplify();
    if (!ok) return false;

// artur 20070201 doesn't exist in minisat 2.0
//    SearchParams    params(0.95, 0.999, 0.02);
// pchong 20060804 - fix for minisat 1.14
//    double  nof_learnts   = nConstrs() / 3;
    double  nof_learnts   = nClauses() / 3;
    lbool   status        = l_Undef;

    for (int i = 0; i < assumps.size(); i++) {
        newDecisionLevel();
        if (!enqueue(assumps[i]) || propagate() != NULL){
// pchong 20060804 - fix for minisat 1.14
//            propQ.clear();
            qhead = trail.size();
            cancelUntil(0);
            return false; }
    }
// artur 20070201 doesn't exist in minisat 2.0
//    root_level = decisionLevel();

    while (status == l_Undef && conflicts < maxConflicts){
        if (verbosity >= 1) {
            cout << "Solving -- conflicts=" << maxConflicts 
                 << "   learnts=" << nof_learnts 
                 << "   progress=" << setprecision(4) << progress_estimate*100
                 << endl;
        }
        status = search((int)maxConflicts, (int)nof_learnts);
        nof_learnts   *= 1.1;
    }

// donald 20070414 someone forgot to copy the rest of the method...
    if (status == l_True){
        // Extend & copy model:
        model.growTo(nVars());
        for (int i = 0; i < nVars(); i++) model[i] = value(i);
#ifndef NDEBUG
        if (verbosity >= 1)
           verifyModel();
#endif
    }else{
        assert(status == l_False);
        if (conflict.size() == 0)
            ok = false;
    }

    cancelUntil(0);
    return status;
}

void
CircuitSatSolver::addNotGate(const Lit   &a,
                             const Lit   &o)
{
    vec<Lit> lits(2);

    // (a + o)
    lits[0] = a;
    lits[1] = o;
    addClause(lits);

    // (~a + ~o)
    lits[0] = ~a;
    lits[1] = ~o;
    addClause(lits);
}

void
CircuitSatSolver::addAndGate(const Lit   &a,
                             const Lit   &b,
                             const Lit   &o)
{
    addOrGate(~a, ~b, ~o);
}

void
CircuitSatSolver::addOrGate(const Lit   &a,
                            const Lit   &b,
                            const Lit   &o)
{
    vec<Lit> lits(2);

    // (~a + o)
    lits[0] = ~a;
    lits[1] = o;
    addClause(lits);

    // (~b + o)
    lits[0] = ~b;
    addClause(lits);

    // (a + b + ~o)
    lits[0] = a;
    lits[1] = b;
    lits.push(~o);
    addClause(lits);
}

void
CircuitSatSolver::addXorGate(const Lit   &a,
                             const Lit   &b,
                             const Lit   &o)
{
    vec<Lit> lits(3);

    // (a + b + ~o)
    lits[0] = a;
    lits[1] = b;
    lits[2] = ~o;
    addClause(lits);

    // (~a + b + o)
    lits[0] = ~a;
    lits[1] = b;
    lits[2] = o;
    addClause(lits);

    // (a + ~b + o)
    lits[0] = a;
    lits[1] = ~b;
    lits[2] = o;
    addClause(lits);

    // (~a + ~b + ~o)
    lits[0] = ~a;
    lits[1] = ~b;
    lits[2] = ~o;
    addClause(lits);
}

void
CircuitSatSolver::addAndGate(const vec<Lit>  &as,
                             const Lit       &o)
{
    vec<Lit> lits;

    as.copyTo(lits);
    for (int i = 0; i < lits.size(); ++i) {
        lits[i] = ~lits[i];
    }
    addOrGate(lits, ~o);
}

void
CircuitSatSolver::addOrGate(const vec<Lit>   &as,
                            const Lit        &o)
{
  vec<Lit> lits(2);

  // (~a_i + o)
  lits[0] = o;
  for (int i = 0; i < as.size(); ++i) {
    lits[1] = ~as[i];
    addClause(lits);
  }

  // (... + a_i + ... + ~o)
  as.copyTo(lits);
  lits.push(~o);
  addClause(lits);
}

}
