#if !defined(oagSswAiSimEngine_P)
#define oagSswAiSimEngine_P

#include "oagAiGraph.h"
#include "oagSswBitVector.h"
#include "oagSswMap.h"

namespace oagSsw
{

class AiSimEngine {
  public:
                            AiSimEngine(oagAi::Graph & graph);
    
                            /// \brief length of simulation vectors
    oa::oaUInt4             getLength();          
                            /// \brief change length of vectors                                
    void                    setLength(oa::oaUInt4 length);                     
                            /// \brief get a bit from vector  
    bool                    getBit(oagAi::Ref   e,
                                   oa::oaUInt4  bitIdx);           
                            /// \brief set a bit in vector   
    void                    setBit(oagAi::Ref   e,
                                   oa::oaUInt4  bitIdx,
                                   bool         val);     
    oa::oaUInt4             getWord(oagAi::Ref  e,
                                    oa::oaUInt4 wordIdx);
                            /// \brief propagate input vectors to outputs 
    void                    simulateAll(bool onlyLastWord = false);             
                            /// \brief propagate vectors in a transitive fanin
    void                    simulateTransitiveFanIn(oagAi::Ref e,
                                                    bool onlyLastWord = false);    
                            /// \brief set some bits of vectors of var vertices to random bits
                            /// to = exclusive
    void                    randomizeVars(oa::oaUInt4 from,
                                          oa::oaUInt4 to); 
    /// \brief compare vectors for sorting (-1, 0, 1 for <, = , >)
    ///
    /// The sort order is somewhat arbitrary,  but consistent.
    /// \param modCompl modulo complementation: Considers complements
    /// to be equal.
    int                     compareRef(oagAi::Ref e1,
                                       oagAi::Ref e2,
                                       bool       modCompl = false);  
    bool                    maskedEquivalent(oagAi::Ref &e1,
                                             oagAi::Ref &e2,
                                             const BitVector &mask);
                            /// \brief get number of simulation words
    oa::oaUInt4             getNumWords();                            
    void                    clear();
                            /// \brief dump simulation vectors for all vertices
    void                    dumpAll();
    void                    setSimVectorListLength(oa::oaUInt4 length); 
    
  private:
    oagAi::Graph            &graph;
    oa::oaUInt4             numBits;
    vector<BitVector>       simVectors;
 
    static const BitVector::Word    FULL_WORD;
   
    oa::oaUInt4             getIndex(oagAi::Ref e);
    oa::oaUInt4             wordLength(oa::oaUInt4 bitLen);
    oa::oaUInt4             shiftl(BitVector::Word  w,
                                   oa::oaUInt4      n);
    BitVector::Word         wordMask(oa::oaUInt4 from,
                                     oa::oaUInt4 to);
    BitVector::Word         getWordInternal(oagAi::Ref  e,
                                            oa::oaUInt4 wordIdx);
    void                    simulateAnd(oagAi::Ref  e,
                                        bool        onlyLastWord = false);
    void                    simulateTransitiveFanInRec(oagAi::Ref   e, 
                                                       bool         onlyLastWord,
                                                       vector<bool> &updated);
    BitVector::Word         randomWord();  

    friend class OdcSatSweepingEngine;
};

}

#endif
