#if !defined(oagSswAiReasoningEngine_P)
#define oagSswAiReasoningEngine_P

#include "oagAiGraph.h"
#include "oagFuncReasoningEngine.h"

namespace oagSsw
{

class AiReasoningEngine : public oagFunc::ReasoningEngine<oagAi::Ref> {
public:
  AiReasoningEngine(oagAi::Graph & graph) : graph(graph) { }
  virtual oagAi::Ref getZero() { 
    return graph.constantZero(); 
  }
  virtual oagAi::Ref andOf(oagAi::Ref a, oagAi::Ref b) {
    return graph.andOf(a, b);
  }
  virtual oagAi::Ref notOf(oagAi::Ref a) {
    return graph.notOf(a);
  }
  oagFunc::GenericFunction genericNewTerminal() {
    return getFunc(graph.newTerminal(graph.getNull()));
  }
  oagAi::Ref getRef(oagFunc::GenericFunction f) {
    return castS(f);
  }
  oagFunc::GenericFunction getFunc(oagAi::Ref x) {
    return castG(x);
  }

  oagAi::Graph & getGraph() {
    return graph;
  }

private:
  oagAi::Graph & graph;
};

}

#endif
