#if !defined(oagSswAiGraphUtil_P)
#define oagSswAiGraphUtil_P

#include "oagAiGraph.h"

namespace oagSsw
{

// Some helper utilities for oagAi::Graph
class AiGraphUtil {
public:
  static void       getTransitiveFanin(oagAi::Graph             &graph,
                                       const list<oagAi::Ref>   &refs,
                                       list<oagAi::Ref>         &transitiveFanin);
  static void       getTransitiveFanout(oagAi::Graph            &graph,
                                        const list<oagAi::Ref>  &refs,
                                        list<oagAi::Ref>        &transitiveFanout);

  /// \brief If input is one of x's inputs, returns the other input of x.
  static oagAi::Ref         getAndOther(oagAi::Graph    &graph,
                                        oagAi::Ref      x,
                                        oagAi::Ref      input);
};

}

#endif
