#if !defined(oagSswAiBitVectorDict_P)
#define oagSswAiBitVectorDict_P

#include <climits>
#include <vector>
#include <iterator>
#include "oaBase.h"
#include "oagSswAiSimEngine.h"
#include "oagSswBitVector.h"

namespace oagSsw
{

using oa::oaUInt4;

/// Dictionary of simulation vectors for and/inverter refs.
class AiBitVectorDict {
  public:
                            AiBitVectorDict(AiSimEngine             &simEngine);
                            ~AiBitVectorDict();

    /// \brief Clears the dictionary and sets up new parameters.
    ///
    /// This function should be called before inserting refs.
    void                    initialize(const vector<oaUInt4>    &bitOrder,
                                       oaUInt4                  maxBinSize);

    void                    insert(oagAi::Ref x);

    /// \brief Finds the refs in the dictionary whose simulation vectors are
    /// identical to \a x's vector, except possibly at the positions where
    /// the bits of \a mask are 0.
    /// \param x
    /// \param mask
    /// \retval matches contains the refs with compatible vectors
    void                    search(oagAi::Ref       x,
                                   const BitVector  &mask,
                                   list<oagAi::Ref> &matches) const;

  private:
    class TrieNode;
    class TrieBranch;
    class TrieLeaf;

    /// \brief Recursively inserts a ref into the trie.
    /// 
    /// Creates new branches as needed.
    /// \return \a trie, or a new branch if one is created
    TrieNode                *insertRec(oagAi::Ref   x,
                                       TrieNode     *trie,
                                       oaUInt4      depth);
    void                    searchRec(oagAi::Ref        x,
                                      const BitVector   &mask,
                                      TrieNode          *trie,
                                      oaUInt4           depth,
                                      list<oagAi::Ref>  &matches) const;

    AiSimEngine             &simEngine;
    vector<oaUInt4>         bitOrder;
    TrieNode                *trie;
    oaUInt4                 maxBinSize;

    class TrieNode {
      public:
                            TrieNode(bool isLeaf) : isLeaf(isLeaf) {}
        const bool          isLeaf;
    };

    class TrieBranch : public TrieNode {
      public:
                            TrieBranch(TrieNode *child0,
                                       TrieNode *child1);
                            ~TrieBranch();
        TrieNode            *child[2];
    };

    class TrieLeaf : public TrieNode {
      public:
                            TrieLeaf() : TrieNode(true) {}

        typedef vector<oagAi::Ref>  Bin;
        Bin                         bin;
    };
};

}

#endif
