
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

#include <fstream>
#include <string>
#include <iostream>
#include "oagResynUserPattern.h"
#include "oagResynUtil.h"

using namespace std;
using namespace oa;

// #define DEBUG

namespace oagResyn {

/// Set file 
/// 
/// \param fileName Filename of the source file
/// \return true if success.
bool userPattern::setFile(oaDesign* design, const char* fileName)
{
    string token;
    oaBlock* block= design->getTopBlock();
    oaNet* net;
    
    myNets.clear();
    
    iFile.open(fileName, ios::in);
    if (iFile.is_open())
    {
        // Parse nets
        while (util::getToken(iFile, token) == 0)
        {   
            const oa::oaNativeNS nativeNS;
            oaName name1(nativeNS, static_cast<const oaChar*>(token.c_str()));
            net= oaNet::find(block, name1);
            if (net == NULL)
            {
                cout<<"Net "<<token<<" not found, ignored."<<endl;
            }
            myNets.push_back(net);
        }
        return true;
    }
    else
        return false;
}

/// Get nets
void userPattern::getNets(std::vector<oa::oaNet*>& nets)
{
    nets= myNets;
}

/// Get a vector from the file
///
/// \return false if EOF encounterd
bool userPattern::getVector(std::vector<SimulationVector>& vec)
{
    unsigned int i;
    string token;
    int result;
    SimulationVector simVal;
    bool valid= true;
    bool eof= true;
    
    vec.clear();
    for (i= 0; i < myNets.size(); i++)
    {
        if (valid)
        {
            result= util::getToken(iFile, token);
            if (result == 0)
            {
                if (SimVectorSize == 32)
                    simVal= atol(token.c_str());
                else 
                    simVal= atoll(token.c_str());
            }
            else if (result == 1)
            {
                valid= false;
            }
            else if (result == 2)
            {
                valid= false;
                iFile.close();
                eof= false;
            }
        }
        else
            simVal= 0;
        vec.push_back(simVal);
    }
    result= util::getToken(iFile, token);
    if (result == 2)
    {
        iFile.close();
        eof= false;
    }
    return eof;
}

/// Check if patterns have been exhausted.
///
/// \return true if finished
bool userPattern::isFinished()
{
    if (iFile.is_open())
        return false;
    else
        return true;
}


} // End of namespace
// vim: ci et sw=4 sts=4
