/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

#include <iostream>
#include <fstream>
#include <string>
#include <set>
#include <list>
#include <algorithm>
#include "oagResynUtil.h"
#include "oagResynOptCktOper.h"

using namespace std;
using namespace oa;

//#define DEBUG

namespace oagResyn {


// *****************************************************************************
// injectRandomBug()
//
/// \brief Inject a random bug into the circuit. Return the modified target gate.
//
// *****************************************************************************
optSimInst* optCktOper::injectRandomBug()
{
    int type;
    optSimInst* tgtGate;
    map<oa::oaInst*, optSimInst*>::iterator mapIter;
    vector<optSimInst*> instVec;
    string instName;
    unsigned int tgtInputNO, tgtOutputNO;
    vector<string> cellNames;

    // Build a vector of instances
    // Randomly select an instance, which cannot be a register
    for (mapIter= ckt1->instMap.begin(); mapIter != ckt1->instMap.end(); mapIter++)
    {
        if ((*mapIter).second->isStateReg == false &&
            (*mapIter).second->inputs.empty() == false &&
            (*mapIter).second->outputs.empty() == false)
        {
            instVec.push_back((*mapIter).second);
        }
    }
    tgtGate= instVec[rand() % instVec.size()];
    tgtInputNO= tgtGate->inputs.size();
    tgtOutputNO= tgtGate->outputs.size();
    instName= getNameFromOA(tgtGate->origInst);
    cout<<"Inject random error into gate: "<<instName<<endl;
    cout<<"Level: "<<tgtGate->level<<endl;
    type= rand() % 6;
    if (type == 0 || type == 1 || type == 2)
    {
        // type 0: wrong gate type, 1: extra wire, 2: missing wire
        optSimInst* newInst;
        string modName;
        vector<string>::iterator strIter;
        libCell* newLibCell;
        vector<optSimWire*> inputWires, outputWires;
        vector<optSimPort*>::iterator portIter;
        vector<string> validTypes;
        string newType;
        unsigned long long origVal;
        int i;
        
        ckt1->instGetModName(tgtGate->origInst, modName);
        libManager.getCellNames(cellNames);
        if (tgtGate->inputs.size() <= 4)
            origVal= tgtGate->cell->tTables[0].to_ulong();
        for (strIter= cellNames.begin(); strIter != cellNames.end(); strIter++)
        {
            if (modName.compare(*strIter) == 0)
                continue;
            newLibCell= libManager.lookUpCell(*strIter);
            if (newLibCell->inputNames.size() <= 4 &&
                newLibCell->tTables[0].to_ulong() == origVal)
                continue;
            if ((newLibCell->inputNames.size() == tgtInputNO && type == 0 ||
                 newLibCell->inputNames.size() == tgtInputNO + 1 && type == 1 ||
                 newLibCell->inputNames.size() == tgtInputNO - 1 && type == 2)&&
                 newLibCell->outputNames.size() == tgtOutputNO)
            {
                validTypes.push_back(*strIter);
            }
        }
        if (validTypes.empty())
        {
            cout<<"Error injection failed"<<endl;
            return NULL;
        }
        newType= validTypes[rand() % validTypes.size()];
        for (portIter= tgtGate->inputs.begin(); 
             portIter != tgtGate->inputs.end();
             portIter++)
        {
            inputWires.push_back((*portIter)->wire1);
        }
        cout<<"Change gate type: original: "<<modName<<", new: "<<newType<<endl;
        // type 1: add another wire
        if (type == 1)
        {
            vector<optSimWire*> extraWires;
            optSimWire* eWire;
            ckt1->findWireClose(tgtGate->outputs[0]->wire1, 20, extraWires);
            if (extraWires.empty())
                return NULL;
            eWire= extraWires[rand() % extraWires.size()];
            inputWires.push_back(eWire);
            cout<<"Extra wire: "<<getNameFromOA(eWire->origWire)<<endl;
        }
        // type 2: remove one wire
        if (type == 2)
        {
            cout<<"Missing wire: "<<getNameFromOA(inputWires[inputWires.size()-1]->origWire)<<endl;
            inputWires.pop_back();
        }
        for (portIter= tgtGate->outputs.begin(); 
             portIter != tgtGate->outputs.end();
             portIter++)
        {
            outputWires.push_back((*portIter)->wire1);
        }
        ckt1->destroyInst(tgtGate);
        // Create a new gate using a differne type
        newInst= ckt1->addInst(instName, newType);
        // Connect ports
        i= 0;
        for (portIter= newInst->inputs.begin(); 
             portIter != newInst->inputs.end();
             portIter++)
        {
            (*portIter)->connectWire(inputWires[i++]);
        }
        i= 0;
        for (portIter= newInst->outputs.begin(); 
             portIter != newInst->outputs.end();
             portIter++)
        {
            (*portIter)->connectWire(outputWires[i++]);
        }
        return newInst;
    }
    else if (type == 3)
    {
        // Wrong input
        // Choose one port to change its input
        int changeNO= rand() % tgtGate->inputs.size();
        vector<optSimWire*> extraWires;
        optSimWire* eWire;
        ckt1->findWireClose(tgtGate->inputs[changeNO]->wire1, 20, extraWires);
        if (extraWires.empty())
            return NULL;
        eWire= extraWires[rand() % extraWires.size()];
        cout<<"Change input "<<getNameFromOA(tgtGate->inputs[changeNO]->wire1->origWire);
        cout<<" to "<<getNameFromOA(eWire->origWire)<<endl;
        tgtGate->inputs[changeNO]->removeFromWire();
        tgtGate->inputs[changeNO]->connectWire(eWire);
    }
    else if (type == 4)
    {
        libCell* newLibCell;
        vector<optSimWire*> extraWires;
        optSimInst* newInst;
        string cellName;
        optSimWire* newWire, *oWire;

        // Extra gate
        libManager.getCellNames(cellNames);
        cellName= cellNames[rand() % cellNames.size()];
        newLibCell= libManager.lookUpCell(cellName);
        // Add new gate to the first input
        ckt1->findWireClose(tgtGate->inputs[0]->wire1, newLibCell->inputNames.size() - 1, extraWires);
        if (extraWires.size() < newLibCell->inputNames.size())
            return NULL;
        string id;
        char buf[32];
            
        sprintf(buf, "NewInst%u", serialNO);
        id= buf; 
        cout<<"Extra gate: "<<id<<", type: "<<cellName<<endl;
        serialNO++;
        newInst= ckt1->addInst(id, cellName);
        sprintf(buf, "NewWire%u", serialNO);
        id= buf; 
        serialNO++;
        newWire= ckt1->addWire(id);
        oWire= tgtGate->inputs[0]->wire1;
        tgtGate->inputs[0]->removeFromWire();
        tgtGate->inputs[0]->connectWire(newWire);
        newInst->outputs[0]->connectWire(newWire);
        for (unsigned int i= 0; i < newInst->inputs.size() - 1; i++)
        {
            newInst->inputs[i]->connectWire(extraWires[i]);
        }
        // Last input connects to the original driver
        newInst->inputs[newInst->inputs.size() - 1]->connectWire(oWire);
        cout<<"Inputs for extra gate:";
        for (unsigned int i= 0; i < newInst->inputs.size(); i++)
            cout<<" "<<getNameFromOA(newInst->inputs[i]->wire1->origWire);
        cout<<endl;
    }
    else if (type == 5)
    {
        unsigned int i;
        optSimWire* iWire, *oWire;

        cout<<"Remove gate."<<endl;
        for (i= 0; i < tgtGate->outputs.size(); i++)
        {
            vector<optSimPort*> ports;
            // Missing gate
            oWire= tgtGate->outputs[i]->wire1;
            ports= oWire->outputs;
            iWire= tgtGate->inputs[i]->wire1;
            for (unsigned int j= 0; j < ports.size(); j++)
            {
                ports[j]->connectWire(iWire);
            }
            ckt1->destroyWire(oWire);
        }
        ckt1->destroyInst(tgtGate);
    }
    return tgtGate;
}

// *****************************************************************************
// randomResynthesize()
//
/// \brief Randomly resynthesize a group of gates.
//
// *****************************************************************************
optSimInst* optCktOper::randomResynthesize()
{
    optSimInst* tgtGate;
    map<oa::oaInst*, optSimInst*>::iterator mapIter;
    vector<optSimInst*> instVec;
    vector<optSimInst*>::iterator instIter;
    vector<optSimWire*>::iterator wireIter;
    string instName;
    unsigned int tgtInputNO, tgtOutputNO;
    vector<optSimWire*> wires, inputs, outputs, others, sinputs, soutputs;
    vector<optSimInst*> insts;
    unsigned int i;
    ifstream ifile;
    int status;    
    util util1;
    string token, gateType, wireName;
    libCell* libCell2;
    optSimInst* newInst;

    // Build a vector of instances
    // Randomly select an instance, which cannot be a register
    for (mapIter= ckt1->instMap.begin(); mapIter != ckt1->instMap.end(); mapIter++)
    {
        if ((*mapIter).second->isStateReg == false &&
            (*mapIter).second->inputs.empty() == false &&
            (*mapIter).second->outputs.empty() == false)
        {
            instVec.push_back((*mapIter).second);
        }
    }
    tgtGate= instVec[rand() % instVec.size()];
    tgtInputNO= tgtGate->inputs.size();
    tgtOutputNO= tgtGate->outputs.size();
    instName= getNameFromOA(tgtGate->origInst);
    cout<<"Randomlly resynthesize gates near gate: "<<instName<<endl;
    cout<<"Level: "<<tgtGate->level<<endl;
    for (i= 0; i < tgtGate->outputs.size(); i++)
    {
        wires.push_back(tgtGate->outputs[i]->wire1);
    }
    ckt1->getInputSimInsts(wires, insts, 20);
    ckt1->optSimInstsGetSubcktIO(insts, inputs, outputs, others);
    ckt1->generateBlif("resyn.blif", insts, inputs, outputs);
    // Now remove all instances in the original subcircuit
    for (instIter= insts.begin(); instIter != insts.end(); instIter++)
        ckt1->destroyInst(*instIter);

    // Now remove all wires in others
    for (wireIter= others.begin(); wireIter != others.end(); wireIter++)
        ckt1->destroyWire(*wireIter);
    // Now call ABC to resynthesize the subcircuit
    system("abc < abc_resyn.script");
    // Now reconstruct from resyn_out.blif
    ifile.open("resyn_out.blif", ios::in);
    if (ifile.is_open() == false)
        return NULL;
    do
    {
        status= util1.getToken(ifile, token);
        if (status == 0 && token.compare(".gate") == 0)
        {
            status= util1.getToken(ifile, gateType);
            libCell2= libManager.lookUpCell(gateType);
            if (libCell2 == false) // Cannot find the gate
                return NULL;
            // Read input
            for (i= 0; i < libCell2->inputNames.size(); i++)
            {
                oaNet* net2;
                oa::oaNativeNS ns;
                optSimWire* newWire;

                status= util1.getToken(ifile, wireName);
                // Kill everything before =
                wireName= wireName.substr(wireName.find("=")+1);
//                if (wireName.find("[") != string::npos)
//                    wireName.replace(wireName.find("["), 1, "lb_");
//                if (wireName.find("]") != string::npos)
//                    wireName.replace(wireName.find("]"), 1, "_rb");
                // Check if the net exists or not
                oaName name2(ns, wireName.c_str());
                net2= oaNet::find(ckt1->block, name2);
                if (net2 == NULL)
                    newWire= ckt1->addWire(wireName);
                else
                    newWire= ckt1->netGetSimWire(net2);
                sinputs.push_back(newWire);
            }
            // Read output
            {
                oaNet* net2;
                oa::oaNativeNS ns;
                optSimWire* newWire;

                status= util1.getToken(ifile, wireName);
                // Kill everything before =
                wireName= wireName.substr(wireName.find("=")+1);
//                if (wireName.find("[") != string::npos)
//                    wireName.replace(wireName.find("["), 1, "lb_");
//                if (wireName.find("]") != string::npos)
//                    wireName.replace(wireName.find("]"), 1, "_rb");
                // Check if the net exists or not. Make sure the nets exist
                // before connecting them.
                oaName name2(ns, wireName.c_str());
                net2= oaNet::find(ckt1->block, name2);
                if (net2 == NULL)
                    newWire= ckt1->addWire(wireName);
                else
                    newWire= ckt1->netGetSimWire(net2);
                soutputs.push_back(newWire);
            }
            // Now we can insert the instance and connect the ports
            string id;
            char buf[32];
            
            sprintf(buf, "NewInst%u", serialNO);
            id= buf; 
            serialNO++;
            newInst= ckt1->addInst(id, gateType);
            // Now connect the ports
            for (i= 0; i < libCell2->inputNames.size(); i++)
                newInst->inputs[i]->connectWire(sinputs[i]);
            newInst->outputs[0]->connectWire(soutputs[0]);
            sinputs.clear();
            soutputs.clear();
        }
    } while (status != 2);
    return tgtGate;
}

/// Randomlly inject a sequential bug into a design by inserting/removing one 
/// register
/// \param dffCellName the cell name for the register to be inserted
void optCktOper::injectRandomSeqBug(string dffCellName)
{
    int type;
    optSimWire* wire2, *newWire, *wire3;
    vector<oaNet*> nets;
    vector<oaInst*> insts;
    optSimInst* newInst, *inst2;
    vector<optSimPort*>::iterator portIter, portIter2;
    bool PI, PO;

    type= rand() % 2;
    if (type == 0)
    {
	// Delete a register and connect its output to input
        ckt1->getStates(insts);
	while (true)
        {
            PI= false;
            PO= false;
	    inst2= ckt1->instGetSimInst(insts[random() % insts.size()]);
            for (portIter= inst2->inputs.begin(); portIter != inst2->inputs.end(); portIter++)
            {
                if (dffD.compare(getNameFromOA((*portIter)->origPort)) == 0 &&
                    (*portIter)->wire1 && (*portIter)->wire1->isPI)
                    PI= true;
            }
            for (portIter= inst2->outputs.begin(); portIter != inst2->outputs.end(); portIter++)
            {
                if (dffQ.compare(getNameFromOA((*portIter)->origPort)) == 0 &&
                    (*portIter)->wire1 && (*portIter)->wire1->isPO ||
                    dffQN.compare(getNameFromOA((*portIter)->origPort)) == 0 &&
                    (*portIter)->wire1 && (*portIter)->wire1->isPO)
                    PO= true;
            }
            if (PI == false && PO == false)
                break;
	} 
        for (portIter= inst2->inputs.begin(); portIter != inst2->inputs.end(); portIter++)
        {
            if (dffD.compare(getNameFromOA((*portIter)->origPort)) == 0)
            {
                wire2= (*portIter)->wire1;
            }
        }
        for (portIter= inst2->outputs.begin(); portIter != inst2->outputs.end(); portIter++)
        {
            if (dffQ.compare(getNameFromOA((*portIter)->origPort)) == 0 ||
                dffQN.compare(getNameFromOA((*portIter)->origPort)) == 0)
            {
                wire3= (*portIter)->wire1;
                if (wire3 == NULL)
                    continue;
                for (portIter2= wire3->outputs.begin(); portIter2 != wire3->outputs.end(); portIter2++)
                {
                    (*portIter2)->connectWire(wire2);
                }
                ckt1->destroyWire(wire3);
            }
        }
        ckt1->destroyInst(inst2);
    }
    else
    {
	string newName;
	
	// Insert a register to a random wire
	ckt1->getAllNets(nets);
	do
	{
	    wire2= ckt1->netGetSimWire(nets[random() % nets.size()]);
	} while (wire2 == NULL && wire2->isPI == false && wire2->isPO == false);
	// Add a register to the driver of the wire
	newName= "addedRndReg";
        newInst= ckt1->addInst(newName, dffCellName);
        newName= "addedRndWire";
        newWire= ckt1->addWire(newName);
        wire2->driver->connectWire(newWire);
        for (portIter= newInst->inputs.begin(); portIter != newInst->inputs.end(); portIter++)
        {
            if (dffD.compare(getNameFromOA((*portIter)->origPort)) == 0)
            {
                (*portIter)->connectWire(newWire);
            }
        }
        for (portIter= newInst->outputs.begin(); portIter != newInst->outputs.end(); portIter++)
        {
            if (dffQ.compare(getNameFromOA((*portIter)->origPort)) == 0)
            {
                (*portIter)->connectWire(wire2);
            }
        }
    }
}

/// Randomlly inject a connection bug to registers by either swapping the
/// connection of two registers or removing one fanout from a register
void optCktOper::injectRandomRegBug()
{
    vector<oaInst*> states;
    vector<optSimInst*> regs2;
    vector<oaInst*>::iterator instIter;
    vector<optSimPort*>::iterator portIter;
    optSimInst* inst2;
    int type;

    ckt1->getStates(states);
    // collect registers whose outputs fanout to >1 gates
    for (instIter= states.begin(); instIter != states.end(); instIter++)
    {
        inst2= ckt1->instGetSimInst(*instIter);
        for (portIter= inst2->outputs.begin(); portIter != inst2->outputs.end();
             portIter++)
        {
            if ((*portIter)->wire1 && (*portIter)->wire1->isRegOut && (*portIter)->wire1->outputs.size() > 1)
                regs2.push_back(inst2);
        }
    }
    if (regs2.empty() && states.size() < 2)
    {
        cout<<"Cannot inject this type of error."<<endl;
        return;
    }
    if (regs2.empty())
        type= 0;
    else if (states.size() < 2)
        type= 1;
    else 
        type= rand() % 2;
    if (type == 0)
    {
        // Swap connection between two registers
        int s1, s2;
        optSimWire* wire1, *wire2;
        optSimPort* port1, *port2;
        do
        {
            s1= rand() % states.size();
            s2= rand() % states.size();
        } while (s1 == s2);
        inst2= ckt1->instGetSimInst(states[s1]);
        for (portIter= inst2->inputs.begin(); portIter != inst2->inputs.end();
             portIter++)
        {
            wire1= (*portIter)->wire1;
            if (wire1->isRegD)
            {
                port1= *portIter;
                break;
            }
        }
        inst2= ckt1->instGetSimInst(states[s2]);
        for (portIter= inst2->inputs.begin(); portIter != inst2->inputs.end();
             portIter++)
        {
            wire2= (*portIter)->wire1;
            if (wire2->isRegD)
            {
                port2= *portIter;
                break;
            }
        }
        port1->connectWire(wire2);
        port2->connectWire(wire1);
    }
    else
    {
        // Remove one fanout from a register
        inst2= regs2[rand() % regs2.size()];
        for (portIter= inst2->outputs.begin(); portIter != inst2->outputs.end();
             portIter++)
        {
            if ((*portIter)->wire1 && (*portIter)->wire1->isRegOut && (*portIter)->wire1->outputs.size() > 1)
            {
                optSimPort* port2;
                port2= (*portIter)->wire1->outputs[0];
                // Connect it to tie0/tie1 or any PI
                if (ckt1->tie0Wire)
                    port2->connectWire(ckt1->tie0Wire);
                else if (ckt1->tie1Wire)
                    port2->connectWire(ckt1->tie1Wire);
                else
                {
                    vector<oaNet*> inputs;
                    ckt1->getInputs(inputs);
                    port2->connectWire(ckt1->netGetSimWire(inputs[rand() % inputs.size()]));
                }
                break;
            }
        }
    }
}

} // End of namespace
// vim: ci et sw=4 sts=4
