
/* 
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResyn.h
/// Global definitions.

#if !defined(oagResyn_P)
#define oagResyn_P

#include <map>
#include <string>
#include "oagResynType.h"
#include "oagResynCktMan.h"
#include "oagResynUserIntf.h"

namespace oagResyn {

/// Keywords used by setKeyWords
enum keyWords {DFFKEY, DFFD, DFFQ, DFFQN, DFFCLK, TIE1, TIE0};

extern std::string dffQ;
extern std::string dffQN;
extern std::string dffCLK;
extern std::string dffD;
extern std::string dffKey;
extern std::string tie1, tie0;

void setKeyWords(keyWords key, char* str);
std::auto_ptr<simulatorInterface> getSimulator(int argc, const char **argv) throw(oagResynErr, oa::oaException);
std::auto_ptr<equiCheckOutputInterface> getEquiResult(int argc, const char **argv) throw (oagResynErr, oa::oaException);
void doSimulation(oa::oaDesign *design, int cycles);
int simulationMain(int argc, const char **argv);
std::auto_ptr<equiCheckOutputInterface> increVeriMain(int argc, const char **argv) throw(oagResynErr, oa::oaException);

std::auto_ptr<simulatorInterface> getSimulator(const std::string& lib, 
              const std::string& cell, const std::string& liberty, 
              const int seed=0, const bool useOpt= false,
              const std::string& patternFile = "",
              const std::string& stateFile = "",
              const std::string& view = "",
              const std::string& libDefFile = "",
              const std::string& lib2 = "");

std::auto_ptr<equiCheckOutputInterface> getEquiResultTwoNets(
              const std::string& lib, 
              const std::string& cell, 
              const std::string& net1, 
              const std::string& net2, 
              const std::string& liberty,
              const int randomCycle, const int seed = 0, 
              const std::string& view = "", 
              const std::string& libDefFile = "",
              const std::string& lib2 = "");
              
std::auto_ptr<equiCheckOutputInterface> getEquiResultTwoDesigns(
              const std::string& lib, 
              const std::string& cell1, 
              const std::string& cell2, 
              const std::string& liberty,
              const int randomCycle, const int seed, 
              const std::string& view = "", 
              const std::string& libDefFile= "",
              const std::string& lib2 = "");

extern class LibMan libManager;
extern class cktMan cktManager;
}

#endif

// vim: ci et sw=4 sts=4
