#ifndef oagRedunRTG_P
#define oagRedunRTG_P
#include "oagAiGraph.h"

namespace oagRedun {

/**
 * Random Test Generator for stuck-at faults
 *
 * Allowed modifications to oagAi::Graph:
 *     - removal of test sites using removeTestSite
 *     - Graph::newTraversalID
 *     - Graph::markVisited
 *     - Graph::setUserData
 */
class RTG {
public:
    static RTG* createOAG(oagAi::Graph &_g, const std::vector<oagAi::Ref> &o, unsigned seed);
    virtual void randomSim() = 0;
    virtual bool isTested(oagAi::Ref ref, bool SA1) = 0;
    virtual void removeTestSite(oagAi::Ref ref) = 0;
};

}
#endif
