#ifndef oagRedunCircuitSAT_P
#define oagRedunCircuitSAT_P
#include "oagAiGraph.h"

namespace oagRedun {

/**
 * Circuit-based SAT solver
 *
 * Allowed modifications to oagAi::Graph:
 *     - CircuitSAT::substitute
 *     - Graph::newTraversalID
 *     - Graph::markVisited
 */
struct CircuitSAT {
    enum Result { UNSAT, SAT, TIMEOUT };

    struct {
	unsigned maxNumPropagations;
	unsigned verbosity;
    } params;

    virtual ~CircuitSAT() { }

    virtual Result solve(const std::vector<oagAi::Ref> &assumps) = 0;

    virtual Result isSubstitutable(oagAi::Ref src, oagAi::Ref tgt) = 0;
    virtual void   substitute     (oagAi::Ref src, oagAi::Ref tgt) = 0;

    /// Creates a circuit-SAT solver that natively uses OAGear data structures.
    static CircuitSAT* createOAG(oagAi::Graph &g, const std::vector<oagAi::Ref> &o);
    /// Creates a circuit-SAT solver that uses efficient data structures.
    /** By default, this solver works exactly the same as above. 
     *    \param usedoms Use graph dominators to speed up SAT search.
     */ 
    static CircuitSAT* createXYZ(oagAi::Graph &g, const std::vector<oagAi::Ref> &o, bool usedoms=false);
};

}
#endif
// vim:et:
