/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron Hurst <ahurst@eecs.berkeley.edu>

ChangeLog:
2005-07-20: ChangeLog started
*/

#include "oagDdCuddManager.h"
#include "cuddObj.hh"

using namespace oagDd;

CuddManager::CuddManager() {
    mgr = Cudd_Init(0,0,CUDD_UNIQUE_SLOTS,CUDD_CACHE_SLOTS,0);
}

CuddManager::~CuddManager() {
    // delete mgr;
}

DdNode* 
CuddManager::andOf(DdNode* x, DdNode* y) {
    assert(mgr); 
    assert(x); 
    assert(y);
  
    DdNode *result = Cudd_bddAnd(mgr,x,y);
    Cudd_Ref(result);
    return result;
}

DdNode*
CuddManager::xorOf(DdNode* x, DdNode* y) {
    assert(mgr);
    assert(x);
    assert(y);
                                                                                                                                                                         
    DdNode *result = Cudd_bddXor(mgr,x,y);
    Cudd_Ref(result);
    return result;
}

DdNode*
CuddManager::orOf(DdNode* x, DdNode* y) {
    assert(mgr);
    assert(x);
    assert(y);
                                                                                                                                                                         
    DdNode *result = Cudd_bddOr(mgr,x,y);
    Cudd_Ref(result);
    return result;
}

DdNode* 
CuddManager::notOf(DdNode* x) {
    assert(mgr); 
    assert(x); 

    return Cudd_Not(x);
}
    
DdNode* 
CuddManager::newVariable( ) {
    assert(mgr); 

    return Cudd_bddNewVar(mgr);
}

DdNode* 
CuddManager::getZero( ) {
    assert(mgr); 

    return Cudd_ReadLogicZero(mgr);
}

void
CuddManager::print( DdNode *x ) {
    assert(mgr);
    assert(x);

    Cudd_PrintDebug(mgr, x, 2, 2); 
}
