/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>

#include "oaDesignDB.h"
#include "PlacerInterface.h"

using std::cout;
using std::cerr;
using std::endl;

using oa::oaDesignInit;
using oa::oaLibDefList;
using oa::oaBox;

oaBox myBBox(void)
{
         return oaBox(0,0,10000,10000);
         //TODO make sure this makes sense, fix this to be dependant on design
}

int main(int argc,char **argv)
{
    oaDesignInit();
    oaLibDefList::openLibs();
    const std::string Lib("design"),
          Cell("s386_bench"),
          View("layout");
    oaBox bbox = myBBox();
    //RipUpReplaceRectangle(Lib,Cell,View,bbox,argc,argv);
    
    //save the design
    try 
    {
        oa::oaDesign* _des = 0;
        try
        {
            // Get the oa names 
            oa::oaString        libstr(Lib.c_str());
            oa::oaString        cellstr(Cell.c_str());
            oa::oaString        viewstr(View.c_str());

            // Treat the names  as belonging 
            //to the Native namespace and convert them to oaNames.
            oa::oaNativeNS      ns;
            oa::oaScalarName    libName(ns, libstr);
            oa::oaScalarName    cellName(ns, cellstr);
            oa::oaScalarName    viewName(ns, viewstr);

            _des  = oa::oaDesign::open(libName, cellName, viewName, 'r') ;
        }
        catch (oa::oaException &excp) 
        {
            cerr<<"Can't read Lib/Cell/View "
                <<Lib<<"/"<<Cell<<"/"<<View <<" (check libDefFile)" << endl; 
            cerr<<"OpenAccess exception, Error: \t"<<
                static_cast<const char *>(excp.getMsg()) <<endl;
            exit(1);
        }
        _des->reopen('a');
        _des->save();
    }
    catch (oa::oaException &excp) 
    {
        cerr<<"OpenAcess exception while saving design, Error: "<<
            static_cast<const char *>(excp.getMsg())<<endl;
        exit(1);
    }

    return 0;
}
