/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

#include <iostream>
#include <string>
#include <qpainter.h>
#include "LayoutView/LayoutViewWnd.h"
#include "oagConnect.h"

using std::cerr;
using std::endl;
using std::string;

using oa::oaIter;
using oa::oaInstTerm;
using oa::oaPin;
using oa::oaPinFig;
using oa::oaBox;
using oa::oaTransform;

namespace oagBazaar
{

    //nearly black
#define STD_CELL_FILL_COLOR 10,10,10
    //purple
#define STD_CELL_BORDER_COLOR 128,0,128
    //red
#define PIN_COLOR 255,0,0
    //green
#define NET_COLOR 0,255,0

    const int zoom_factor = 64;

    void LayoutViewWnd::normalize_point(int& x, int& y)
    {
        oagConnection dbConnection(_lib, _cell, _view);
        int cw=dbConnection.getCoreRegionBBox().getWidth(),
            ch=dbConnection.getCoreRegionBBox().getHeight();

        x= x * contentsRect().width() / cw;
        y= (ch - y) * contentsRect().height() / ch;

    }

    void LayoutViewWnd::normalize_distance(int& w, int& h)
    {
        oagConnection dbConnection(_lib, _cell, _view);
        int cw=dbConnection.getCoreRegionBBox().getWidth(),
            ch=dbConnection.getCoreRegionBBox().getHeight();

        w= w * contentsRect().width() / cw;
        h= h * contentsRect().height() / ch;    
    }


}



