/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#if !defined(oagBazaarPlugInAPI_P)
#define oagBazaarPlugInAPI_P

#include <tcl.h>
#include "mainwindow.h"

namespace oagBazaar
{
     ///This class is the only interface that a plug in should have with Bazaar
     /**
        This class contains all of the functions that are necessary for interfacing
        with Bazaar.  There are calls to add menu items, add toolbar buttons and
        button groups, pass widgets to be displayed by Bazaar, etc.
      */
       
     class oagBazaarPlugInAPI
     {
           public:
               oagBazaarPlugInAPI(MainWindow* bazaar);

               QPopupMenu* addMenu(const std::string& name);
               QPopupMenu* addMenu(const std::string& iconName, const std::string& name);
               QToolBar* addToolBar(const std::string& name);

               QAction* createAction(const std::string& command, const std::string& caption, const std::string& statusTip);
               QAction* createAction(const std::string& command, const std::string& caption, const std::string& statusTip, const std::string& iconFileName);

               void addMenuItem(QPopupMenu* menu, QAction* menuItem);
               void addToolBarButton(QToolBar* toolBar, QAction* toolBarButton);

               void giveWidget(QWidget* widget);
               void giveDialog(QDialog* dialog);
               void giveThread(QoagThread* thread);
               void connectCommand(const QObject* sender, const char * signal);

               void registerTCLCommand(Tcl_CmdProc* cmd, const std::string& cmdName, ClientData clientData=0, Tcl_CmdDeleteProc *deleteProc = 0);

               void getActiveDesign(std::string& library, std::string& cell, std::string& view);
            
               void runCommand(const std::string& command);

           private:
               MainWindow* _bazaar;

         
     };

};

#endif



