/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2005-11-07: ChangeLog started
 */
#include <iostream>

#include "DebugLog.h"
#include "oaUtils.h"
#include "QoagCommon/QoagCommon.h"

using std::cout;
using std::endl;
using std::vector;
using std::string;

namespace oagBazaar
{

    vector<string> walkLibDefList(oa::oaLibDefList *list)
    {
        vector<string> libNames;
        if(!list) return libNames;
        //example code taken from OA documentation
        oa::oaType memType;
        oa::oaScalarName libName;
        oa::oaString tempString;
        oa::oaIter<oa::oaLibDefListMem> listIter(list->getMembers());
        vector<string> childrenLibs; //added
        oa::oaLibDefList *nextList=0;
        while (oa::oaLibDefListMem *listMem = listIter.getNext()) 
        { 
            switch (memType = listMem->getType()) {
                case oa::oacLibDefType :
                    ((oa::oaLibDef *)(listMem))->getLibName(libName);
                    libName.get(tempString);
                    //cout << "Got Lib Def: Logical Library Name = "<< tempString << endl; 
                    //process lib def ...
                    libNames.push_back(string(tempString) ); //added
                    break;

                case oa::oacLibDefListRefType :
                    ((oa::oaLibDefListRef *)(listMem))->getRefListPath(tempString);
                    nextList = oa::oaLibDefList::get(tempString,'r');
                    childrenLibs = walkLibDefList(nextList); //changed
                    std::copy(childrenLibs.begin(), childrenLibs.end(), libNames.end());
                    break;

                default:
                    break;
            }
        }
        //end example code taken from OA documentation

        return libNames;
    }

    std::vector<std::string> getCellNamesInLib(const oa::oaLib* lib)
    {
        std::vector<std::string> cellNames;
        if(!lib)
        {
          DebugLog::ostream()<< "getCellNamesInLib given a NULL oaLib*, returning an empty cell list!"<<endl;
          return cellNames; 
        }
        DebugLog::ostream()<<"Reading "<<lib->getCells().getCount()<<" cell names from oaLib*."<<endl;
        oa::oaIter<oa::oaCell> cellIter(lib->getCells());
        while (oa::oaCell *cell = cellIter.getNext()) 
        {
            cellNames.push_back(Qoag::getNameFromOA(cell));
        } 

        return cellNames;
    }

    std::vector<std::string> getCellViewNames(const oa::oaCell* cell)
    {
        std::vector<std::string> viewNames;
        if(!cell) return viewNames;

        oa::oaIter<oa::oaCellView> viewIter(cell->getCellViews());
        while (oa::oaCellView *cellView = viewIter.getNext()) 
        {
            oa::oaView* view = cellView->getView();
            viewNames.push_back(Qoag::getNameFromOA(view));
        }

        return viewNames;
    }

}


