/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file SchemTerm.h */

#ifndef _SCHEM_TERM_H_
#define _SCHEM_TERM_H_

#include <iostream>
#include <qgl.h>
#include "../QoagCommon/QoagCommon.h"
#include "oaDesignDB.h"
#include "oaBase.h"

namespace oagBazaar
{

    namespace Qoag
    {
        ///An object that represents a schematic terminal
        class QoaSchemTerm : public oa::oaBox
        {
            public:
                QoaSchemTerm(const oa::oaModInstTerm *instTerm);
                QoaSchemTerm(const QoaSchemTerm&);
                ~QoaSchemTerm();

                void setTermGeom(oa::oaPoint p, double inst_width);
                oa::oaPoint getTermCenterPoint(void);
                std::string getName(void){ return _termName; }
                GLuint getGlDisplayList(void){ return _displayList; }
                oa::oaModInstTerm const* getInstTerm(void){ return _instTerm; }

                void draw();

                friend std::ostream& operator<<(std::ostream& os, QoaSchemTerm);

            private:
                std::string _termName;
                oa::oaModInstTerm const* _instTerm;
                GLuint _displayList;
        };

    }; //end namespace Qoag

}

#endif

