/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
#include <assert.h>
#include <limits>
#include <vector>

#include "oaBase.h"

#include "SchemTerm.h"
#include "OAGearCommon.h"
#include "DebugLog.h"

using std::cerr;
using std::endl;
using std::numeric_limits;
using std::vector;

using oa::oaString;
using oa::oaPoint;

namespace oagBazaar
{


    namespace Qoag
    {

        using oagBazaar::operator<<;

        QoaSchemTerm::QoaSchemTerm(const oa::oaModInstTerm *instTerm):
            oaBox(numeric_limits<int>::max(), 
                    numeric_limits<int>::max(),
                    numeric_limits<int>::max(),
                    numeric_limits<int>::max() ),
            _termName(""),
            _instTerm(instTerm),
            _displayList(glGenLists(1))
        {
            _termName = getNameFromOA(instTerm->getTerm());
        }

        QoaSchemTerm::QoaSchemTerm(const QoaSchemTerm& orig):
            oaBox( static_cast<oaBox>(orig) ),
            _termName(orig._termName),
            _instTerm(orig._instTerm),
            _displayList(glGenLists(1))
        {
        } 

        QoaSchemTerm::~QoaSchemTerm()
        {
            glDeleteLists(_displayList,1);  
        }

        void QoaSchemTerm::draw()
        {        
            _checkBoundsInit(static_cast<oaBox>(*this), "QoaSchemTerm");

            vector<double> term_border_color;
            setVectorColor(term_border_color, 0.50, 0.55, 0.0);
            vector<double> term_foreground_color;
            setVectorColor(term_foreground_color, 0.0, 0.55, 0.5);

            QoaGlFrameRectd(_displayList,static_cast<oaBox>(*this),
                    0.25,0.25,  //25% border
                    term_border_color,term_foreground_color);

            DebugLog::ostream() << (*this) << endl;
        }

        oaPoint QoaSchemTerm::getTermCenterPoint(void)
        {
            oaPoint rval;
            this->getCenter(rval);
            return rval; 
        }

        void QoaSchemTerm::setTermGeom(oa::oaPoint p, double inst_width)
        {
            double newLeft   = p.x() - Qoag::_term_width*inst_width/2.0;
            double newBottom = p.y() - Qoag::_term_width*inst_width/2.0;
            double newRight  = p.x() + Qoag::_term_width*inst_width/2.0;
            double newTop    = p.y() + Qoag::_term_width*inst_width/2.0;

            set(static_cast<int>(newLeft),
                    static_cast<int>(newBottom), 
                    static_cast<int>(newRight), 
                    static_cast<int>(newTop) );
        }

        std::ostream& operator<<(std::ostream& os, QoaSchemTerm p)
        {
            os<<"SCHEMTERMDEBUG: Info for QoaSchemTerm called: "<<p._termName<<endl;
            os<<"SCHEMTERMDEBUG:    Bounding Box(l,b,r,t): " << static_cast<oa::oaBox>(p) << endl;
            return os;
        }

    }; //end namespace Qoag

}


