/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file SchemInstView.h */

#ifndef SCHEM_CELL_VIEW_H
#define SCHEM_CELL_VIEW_H

#include <qwidgetfactory.h>
#include <qscrollview.h>
#include <qapplication.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qsizegrip.h>
#include <qgl.h>
#include <stdlib.h>
#include <string>
#include <iostream>
#include <vector>

#include "oaDesignDB.h"
#include "oaBase.h"
#include "oagConnect.h"

#include "SchemInstRect.h"
#include "../QoagCommon/QoagCommon.h"

namespace oagBazaar
{

    namespace Qoag
    {
        ///A Qt QGLWidget GUI object that is a schematic browser.
        class QoaSchemInstView : public QGLWidget
        {
            Q_OBJECT
            public:
                QoaSchemInstView(QWidget* parent,
                        const std::string& lib,
                        const std::string& cell,
                        const std::string& view,
                        oa::oaModInst* center_inst=0) ;

                void learnCenterInst(oa::oaModInst* inst);
                void setCenterInst(oa::oaModInst* inst);
                void clear(void);

                void learnInst(oa::oaModInst* inst);

            public slots:
                void resizeGL(int w,int h);
                void initializeGL(void);
                void mousePressEvent(QMouseEvent* event);
                void mouseMoveEvent(QMouseEvent* event);
                void mouseOver(int w, int h);
                void draw(void);
                void paintGL(void);
                void draw_test_pattern(void);
                void draw_test_pattern2(void);

            protected:

                QSize sizeHint(void);
                QSize minimumSizeHint(void);

                void addConnection(const SchemEdgeT& edge );
                void addConnection(oa::oaModInst*, oa::oaModInst*);
                void drawNets(GLuint displayList);
                //Caution!  This function currently searches all terms, use it sparingly.
                //TODO:  Make the following function call an O(1) lookup, and change to getTerm
                QoaSchemTerm* findTerm(oa::oaModInstTerm*);

                void setCenterInst(internalInstIndexT);
                void learnCenterInst(internalInstIndexT);
                void learnInstNeighbors(internalInstIndexT);
                void learnInstNeighbors( oa::oaModInst* source_inst);

                void _windowToGLCoords(oa::oaPoint& p);

                //driver function for the setInstLocations function
                void setInstLocationsOneCenterInstStyle(void);

                //driver function for the setInstLocations function
                void setInstLocationsCenterInstNeighborStyle(void);

                //powerful function to take a list of insts and place them visually by logical connectivity
                void setInstLocations(const std::vector<QoaSchemInstRect*>& inst_list,
                        const std::vector<internalInstIndexT>& inst_indices,
                        double x_column_position,
                        double top_edge,
                        double available_height,
                        double whitespace=0.25);

                friend std::ostream& operator<<(std::ostream& os, QoaSchemInstView);

            private:
                //Caution! inst_vec and inst_indices will be cleared.
                //It will subsequently filled with the input and bidirectional insts 
                //    connected to inst with index source_inst_index
                void getInputInsts(internalInstIndexT source_inst_index,
                        std::vector<QoaSchemInstRect*>& inst_vec,
                        std::vector<internalInstIndexT>& inst_indices);
                //Caution! inst_vec will be cleared.
                //It will subsequently filled with the input and bidirectional insts 
                //    connected to inst with index source_inst_index
                void getInputInsts(internalInstIndexT source_inst_index,
                        std::vector<oa::oaModInst*>& inst_vec);

                //Caution! inst_vec and inst_indices will be cleared.
                //It will subsequently filled with the output insts 
                //    connected to inst with index source_inst_index
                void getOutputInsts(internalInstIndexT source_inst_index,
                        std::vector<QoaSchemInstRect*>& inst_vec,
                        std::vector<internalInstIndexT>& inst_indices);
                //Caution! inst_vec will be cleared.
                //It will subsequently filled with the output insts 
                //    connected to inst with index source_inst_index
                void getOutputInsts(internalInstIndexT source_inst_index,
                        std::vector<oa::oaModInst*>& inst_vec);



                bool _ready;

                oa::oaModInst * _center_inst;
                oa::oaModInst * _mouse_over_inst;

                oagConnection _dbConnection; //ORDER DEPENDENCY
                oagDesignBlock _oagDBlk;        //ORDER DEPENDENCY

                std::map < oa::oaModInst*, internalInstIndexT > _instToIndex;
                std::vector < oa::oaModInst* > _indexToInst;

                //must be updated every time resize occurs or learn happens
                std::vector< QoaSchemInstRect* > _insts;
                std::map< oa::oaModInstTerm*, QoaSchemInstRect* > _oaInstTerm2QoaSchemInstRect;


                std::vector < SchemEdgeT > _edges;
                GLuint _edgeDisplayList;

                std::vector< std::string > _instName;
        };

    }; //end namespace Qoag

}

#endif

