/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file SchemInstRect.h */

#ifndef _SCHEMATIC_INST_RECT_H_
#define _SCHEMATIC_INST_RECT_H_

#include <vector>
#include <string>
#include <map>
#include <iostream>

#include <qstring.h>
#include <qgl.h>

#include "oaBase.h"
#include "oaDesignDB.h"

#include "SchemTerm.h"
#include "../QoagCommon/QoagCommon.h"

namespace oagBazaar
{

    namespace Qoag
    {
        //TODO:  more encapsulation possible, use protected: 
        ///An object that stores an rectangle that represents an oaInst in a QoaSchemInstView
        class QoaSchemInstRect : public oa::oaBox
        {
            friend std::ostream& operator<<(std::ostream& os, QoaSchemInstRect);

            public:
            QoaSchemInstRect(oa::oaModInst *i);
            QoaSchemInstRect(const QoaSchemInstRect&);
            QoaSchemInstRect& operator=(const QoaSchemInstRect&);
            ~QoaSchemInstRect();

            void draw();
            void learnTerms(void);
            void setName(const std::string&);
            std::string getName(void) { return _instName; }
            void setMasterName(const std::string&);
            void setRect(const oa::oaBox& bb);
            void setSelected(bool selected=true);
            QoaSchemTerm* getTerm(int term_num); //TODO: make argument typesafe
            oa::oaModInstTerm* getOAInstTerm(int term_num); //TODO: make argument typesafe

            //Caution!  This function currently searches all terms, use it sparingly.
            //TODO:  Make the following function call an O(1) lookup, 
            //         and change to overload of getTerm
            QoaSchemTerm* getInstTerm(oa::oaModInstTerm* instTerm); 
            oa::oaPoint getTermLoc(int term_num); //TODO: make argument typesafe
            size_t getTermCount(void){ return _allTerms.size(); }
            QString getFullName(void);
            GLuint getGlDisplayList(void){ return _displayList; }

            //this function returns a QString containing
            //A new-line separated string of Term Names from the left side.
            QString getLeftTermsFullString(void);
            //this function returns a QString containing
            //A new-line separated string of Term Names from the right side.
            QString getRightTermsFullString(void);

            void debug_double_check_terms_for_consistancy(void);
            oa::oaModule* _getMasterModule(void);
            unsigned _getNumTermsFromMaster(void);

            //powerful function to take a list of terms and 
            //place them visually by logical connectivity
            void setTermLocations(const std::vector<QoaSchemTerm*>& term_list,
                    double x_column_position,
                    double top_edge,
                    double available_height=0.80,
                    double whitespace=0.25);    

            void draw_test_pattern(void);

            private:
            oa::oaModInst *_inst;

            std::string _instName;
            std::string _masterName;

            GLuint _displayList;

            std::vector< QoaSchemTerm* > _leftTerms;
            std::vector< QoaSchemTerm* > _rightTerms;
            std::vector< QoaSchemTerm* > _allTerms;
            std::vector< oa::oaModInstTerm* > _allOAInstTerms;

            std::map< oa::oaModInstTerm*, QoaSchemTerm* > _oaInstTerm2QoaSchemTerm;
            std::map< QoaSchemTerm*, oa::oaModInstTerm* > _QoaSchemTerm2oaInstTerm;

            bool _selected;
        };

    }; //end namespace Qoag

}

#endif



