/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file LayoutViewWnd.h */

#ifndef SIMILARITY_LAYOUT_VIEW_WND_H
#define SIMILARITY_LAYOUT_VIEW_WND_H

#include <qwidgetfactory.h>
#include <qscrollview.h>
#include <qapplication.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qsizegrip.h>
#include <stdlib.h>
#include <string>
#include <iostream>
#include "oaDesignDB.h"
#include "oaBase.h"
#include "similarityLayoutInstView.h"
#include "oagConnect.h"
#include <vector>

namespace oagBazaar 
{

    ///The Qt QScrollView object that contains a glLayoutWidget
    class similarityLayoutViewWnd : public QScrollView
    {
        Q_OBJECT 
        public:
            similarityLayoutViewWnd(QWidget* parent, 
                                    std::string lib, 
                                    std::string cell, 
                                    std::string view,
                                    const std::vector<oa::oaNet*>* diffNets=0 ); 

            void zoom_in(void);
            void zoom_out(void);

            const std::string& get_lib(void) { return _lib; }
            const std::string& get_cell(void) { return _cell; }
            const std::string& get_view(void) { return _view; }

        protected:
            //removed for now, so that the default resizeEvent is used
            //void resizeEvent(QResizeEvent * e);

        public slots:
            void showCells(void);
            void hideCells(void);
            void showPins(void);
            void hidePins(void);
            void showNets(void);
            void hideNets(void);
            void showPlacing(void);
            void hidePlacing(void);
            void initDesign(void);
            void readOA(void);
            void refresh(void);
            void setModified(void);
            void setUnmodified(void);

        private: //functions
            void readOA(QPainter* p, int cx, int cy, int cw, int ch);
            void plotNets(QPainter* p, const oa::oaBox& box);
            void normalize_point(int& x, int& y);
            void normalize_distance(int& x, int& y);
            void apply_zoom(void);
            //removed for now, so that the default resize behavior is used
            //void resizeSelfAndContents(int width, int height);
            void createLayout(void);
            QSize sizeLayoutPlusFrame(void);
            void setcaption(void);
            bool checkOutputNetDiff(oa::oaInst* inst);
            bool checkInputNetDiff(oa::oaInst* inst);


        private: //data
            bool _drawCells;
            bool _drawPins; 
            bool _drawNets;
            bool _drawPlacing;
            bool _isModified;

            double _zoom_factor;

            oa::oaBox _CoreRegionBBox;
            glSimilarityLayoutWidget* _layout;
            QLabel* _placingLabel;

            std::string _lib;
            std::string _cell;
            std::string _view;

            oa::oaDesign * _des;
            oa::oaBlock * _block;

            const std::vector<oa::oaNet*>* _diffNets; 

    };


}


#endif

