/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


#include <vector>
#include <iostream>
#include <limits>

#include "qfiledialog.h"

#include "oaUtils.h"

void similarityLayoutViewFormT::init()
{
    connect(libComboBox1, SIGNAL(activated(const QString&)), this, SLOT(libChanged1(const QString&)));
    connect(libComboBox2, SIGNAL(activated(const QString&)), this, SLOT(libChanged2(const QString&)));

    
    readLibs1();
    readLibs2();
}

void similarityLayoutViewFormT::libChanged1( const QString & libNameQ )
{
    cellComboBox1->clear();
    
    //std::cout<<"Got lib changed"<<std::endl;
    std::string libName = libNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox1->clear();
    }
    
    if(haveAccess)
    {
      
      std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
      //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
      for(unsigned i = 0 ; i < cellList.size(); ++i)
        cellComboBox1->insertItem(QString(cellList[i].c_str()));
      //cellChanged(QString(cellList[0]));
      lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox1->clear();
     }
}

void similarityLayoutViewFormT::libChanged2( const QString & libNameQ )
{
    cellComboBox2->clear();
    
    //std::cout<<"Got lib changed"<<std::endl;
    std::string libName = libNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox2->clear();
    }
    
    if(haveAccess)
    {
      
      std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
      //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
      for(unsigned i = 0 ; i < cellList.size(); ++i)
        cellComboBox2->insertItem(QString(cellList[i].c_str()));
      //cellChanged(QString(cellList[0]));
      lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox2->clear();
     }
}

void similarityLayoutViewFormT::readLibs1()
{
    //std::cout<<"Reading libs..."<<std::endl;
    std::vector<std::string> libList  = oagBazaar::walkLibDefList(oa::oaLibDefList::getTopList());
    libComboBox1->clear();
    for(unsigned i = 0; i < libList.size(); ++i)
        libComboBox1->insertItem(QString(libList[i].c_str()));
    
    if(!libList.empty())
    {
    //hack to make "designs" default if it exists
    int designsIdx = 0;
    for(unsigned i = 0; i < libList.size(); ++i)
        if(libList[i] == "designs")
        {
            assert( i < static_cast<unsigned>(std::numeric_limits<int>::max()) && "Overflow on lib list");
            designsIdx = static_cast<int>(i);
        }
    
    
    libComboBox1->setCurrentItem(designsIdx);
    libChanged1(QString(libList[designsIdx].c_str()));
    
    }
}

void similarityLayoutViewFormT::readLibs2()
{
    //std::cout<<"Reading libs..."<<std::endl;
    std::vector<std::string> libList  = oagBazaar::walkLibDefList(oa::oaLibDefList::getTopList());
    libComboBox2->clear();
    for(unsigned i = 0; i < libList.size(); ++i)
        libComboBox2->insertItem(QString(libList[i].c_str()));
    
    if(!libList.empty())
    {
    //hack to make "designs" default if it exists
    int designsIdx = 0;
    for(unsigned i = 0; i < libList.size(); ++i)
        if(libList[i] == "designs")
        {
            assert( i < static_cast<unsigned>(std::numeric_limits<int>::max()) && "Overflow on lib list");
            designsIdx = static_cast<int>(i);
        }
    
    
    libComboBox2->setCurrentItem(designsIdx);
    libChanged2(QString(libList[designsIdx].c_str()));
    
    }
}


void similarityLayoutViewFormT::checkEQ()
{
    std::string checkEQCmd = "similarity_layout ";
    checkEQCmd += " -lib ";
    checkEQCmd += static_cast<const char*>(libComboBox1->currentText());
    checkEQCmd += " -lib2 ";
    checkEQCmd += static_cast<const char*>(libComboBox2->currentText());
    checkEQCmd += " -cell1 ";
    checkEQCmd += static_cast<const char*>(cellComboBox1->currentText());
    checkEQCmd += " -cell2 ";
    checkEQCmd += static_cast<const char*>(cellComboBox2->currentText());
    checkEQCmd += " -randomPattern ";
    checkEQCmd += static_cast<const char*>(cyclesEdit->text());
    checkEQCmd += " -liberty ";
    checkEQCmd += static_cast<const char*>(libertyEdit->text());
    
    
      emit checkPressed(checkEQCmd);
      close();
}



void similarityLayoutViewFormT::selectLibertySlot()
{
    QFileDialog * fileDialog = new QFileDialog(this);
    fileDialog->setModal(true);
    fileDialog->exec();
    QString filename = fileDialog->selectedFile();
    libertyEdit->setText(filename);

    delete fileDialog;

}
