/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
#include <qscrollview.h>
#include "similarityLayoutInstView.h"
#include "oagConnect.h"
#include "../../QoagCommon/QoagCommon.h"
#include "DebugLog.h"

using std::cout;
using std::cerr;
using std::endl;

using oagBazaar::Qoag::setVectorColor;
using oagBazaar::Qoag::QoaGlFrameRectd;
using oagBazaar::Qoag::QoaGlRectd;

namespace oagBazaar 
{

    const double lmargin = 0.05; //5%
    const double rmargin = 0.05; //5%
    const double tmargin = 0.05; //5%
    const double bmargin = 0.05; //5%

    glSimilarityLayoutWidget::glSimilarityLayoutWidget(QWidget* parent, const oa::oaBox& coreRegion)
        :QGLWidget(parent,"cellWidget"), _coreRegion(coreRegion),_zoom(1.0)
        {
            setFormat(QGLFormat(DoubleBuffer|DepthBuffer));
            initializeGL();
            resizeCR(coreRegion);
            setZoom(_zoom); //calls resizeGL(_zoom);
        }

    void glSimilarityLayoutWidget::initializeGL()
    {
        qglClearColor(white);
        glShadeModel(GL_FLAT);
        DebugLog::ostream()<<"Initializing gl"<<endl;
    }

    void glSimilarityLayoutWidget::resizeCR(const oa::oaBox& coreRegion)
    {
        _coreRegion = coreRegion;
    }

    void glSimilarityLayoutWidget::resizeGL(double zoom)
    {
        _zoom = zoom;
        int w = static_cast<int>(_coreRegion.getWidth()*_zoom)+1, 
            h = static_cast<int>(_coreRegion.getHeight()*_zoom)+1;
        DebugLog::ostream()<<"Resizing Gl "<<_coreRegion.getWidth()*_zoom<<","<<_coreRegion.getHeight()*_zoom<<" zoom:"<<_zoom<<endl;

        //set the size of this widget, and the glViewport
        //to be the same size
        int newSizeX = static_cast<int>(w * (1.0 + lmargin + rmargin)),
            newSizeY = static_cast<int>(h * (1.0 + bmargin + tmargin));
        resize(newSizeX, newSizeY);
        glViewport(0, 0, newSizeX, newSizeY);

        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        //GLfloat x = (GLfloat) width / height;
        //glFrustum(-x,x,-1.0,1.0,5.0,15.0); 
        //glEnable(GL_DEPTH_TEST);
        //glEnable(GL_CULL_FACE);
        //glOrtho(0, cw, 0, ch, 1.0, -1.0); 
        //glOrtho(0/2.0, width/2.0, 0/2.0, height/2.0, 1.0, -1.0); 



        glOrtho(_coreRegion.getWidth()*-lmargin, _coreRegion.getWidth()*(1.0 + rmargin), 
                _coreRegion.getHeight()*-bmargin, _coreRegion.getHeight()*(1.0+tmargin), 
                1.0, -1.0); 
        glMatrixMode(GL_MODELVIEW);
    }

    void glSimilarityLayoutWidget::paintGL()
    {
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        draw();
        //draw_test_pattern();
    }

    void glSimilarityLayoutWidget::draw_test_pattern()
    {
        qglColor(green);
        glRectd(0,0,100,100);
    }

    void glSimilarityLayoutWidget::draw()
    {
        if(_coreRegion == oa::oaBox(oa::oaCoord(INT_MAX), oa::oaCoord(INT_MAX), oa::oaCoord(-INT_MAX), oa::oaCoord(-INT_MAX)))  
            return;

        qglColor(green);
        glBegin(GL_LINE_STRIP);
        glVertex2d(_coreRegion.left() , _coreRegion.bottom());
        glVertex2d(_coreRegion.left() , _coreRegion.top());
        glVertex2d(_coreRegion.right(), _coreRegion.top());
        glVertex2d(_coreRegion.right(), _coreRegion.bottom());
        glVertex2d(_coreRegion.left() , _coreRegion.bottom());
        glEnd();

        std::vector<double> inst_border_color;
        setVectorColor(inst_border_color, 0.0, 0.25, 0.7); //<---- same blue
        std::vector<double> inst_foreground_color;
        setVectorColor(inst_foreground_color, 0.75, 0.75, 1.0); //<--- gold 

        std::vector<double> alt_border_color;
        setVectorColor(alt_border_color, 0.0, 0.25, 0.7); //<---- same blue
        //std::vector<double> alt_foreground_color;
        //setVectorColor(alt_foreground_color, 0., 1.0, 0.0); //<--- red
        std::vector<double> alt_foreground_color;
        setVectorColor(alt_foreground_color, 0.5, 0.0, 0.0); //<--- darker red

        //for(std::vector<oa::oaBox>::const_iterator it = _insts.begin();
        //        it != _insts.end();
        //        ++it)
        for(unsigned i = 0; i < _insts.size(); ++i)
        {
            if(_inst_colors[i]==1)
            {
                if(_insts.size() > 100) //turn off borders over 1000 insts
                  QoaGlRectd(this, _insts[i], alt_foreground_color); 
                else
                QoaGlFrameRectd(this, _insts[i], 
                        Qoag::_border_size * static_cast<double>(_insts[i].getHeight())/_insts[i].getWidth(), 
                        Qoag::_border_size,
                        alt_border_color, alt_foreground_color);
            }
            else
            {
                if(_insts.size() > 100) //turn off borders over 1000 insts
                  QoaGlRectd(this, _insts[i], inst_foreground_color); 
                else
                QoaGlFrameRectd(this, _insts[i], 
                        Qoag::_border_size * static_cast<double>(_insts[i].getHeight())/_insts[i].getWidth(), 
                        Qoag::_border_size,
                        inst_border_color, inst_foreground_color);
            }
        }
        //DebugLog::ostream()<<"Size: "<<_insts.size()<<endl;
    }

    void glSimilarityLayoutWidget::addInst(const oa::oaBox& new_cell, int color)
    {
        _insts.push_back(new_cell);
        _inst_colors.push_back(color);
    }

    void glSimilarityLayoutWidget::setZoom(double zoom)
    { 
        _zoom = zoom; 
        resizeGL(_zoom); 
        updateGL();
    }

}


