/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <vector>
#include <iostream>
#include <limits>

#include <qfiledialog.h>

#include "oaUtils.h"

void runCycleSimulationFormT::init()
{
    connect(libComboBox, SIGNAL(activated(const QString&)), this, SLOT(libChanged(const QString&)));
 
    readLibs();
}

void runCycleSimulationFormT::libChanged( const QString & libNameQ )
{
    cellComboBox->clear();
    
    //std::cout<<"Got lib changed"<<std::endl;
    std::string libName = libNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
    }
    
    if(haveAccess)
    {
      
      std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
      //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
      for(unsigned i = 0 ; i < cellList.size(); ++i)
        cellComboBox->insertItem(QString(cellList[i].c_str()));
      //cellChanged(QString(cellList[0]));
      lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
     }
}

void runCycleSimulationFormT::readLibs()
{
    //std::cout<<"Reading libs..."<<std::endl;
    std::vector<std::string> libList  = oagBazaar::walkLibDefList(oa::oaLibDefList::getTopList());
    libComboBox->clear();
    for(unsigned i = 0; i < libList.size(); ++i)
        libComboBox->insertItem(QString(libList[i].c_str()));
    
    if(!libList.empty())
    {
    //hack to make "designs" default if it exists
    int designsIdx = 0;
    for(unsigned i = 0; i < libList.size(); ++i)
        if(libList[i] == "designs")
        {
            assert( i < static_cast<unsigned>(std::numeric_limits<int>::max()) && "Overflow on lib list");
            designsIdx = static_cast<int>(i);
        }
    
    
    libComboBox->setCurrentItem(designsIdx);
    libChanged(QString(libList[designsIdx].c_str()));
    
    }
}



void runCycleSimulationFormT::executeSimulator()
{
    std::string simulate_cmd = "simulate ";
    simulate_cmd += " -lib ";
    simulate_cmd += static_cast<const char*>(libComboBox->currentText());
    simulate_cmd += " -cell ";
    simulate_cmd += static_cast<const char*>(cellComboBox->currentText());
    simulate_cmd += " -liberty ";
    simulate_cmd += static_cast<const char*>(libertyEdit->text());
    
    if(!seedEdit->text().isEmpty() && seedEdit->text() != QString("time(0)") )
    {
       simulate_cmd += " -seed ";
       simulate_cmd += static_cast<const char*>(seedEdit->text());
    }
    
    if( customRadioButton->isOn() )
    {
       simulate_cmd += " -useOpt ";
    }
   
    if(!fileEdit->text().isEmpty())
    { 
        simulate_cmd += " -patternFile ";
        simulate_cmd += static_cast<const char*>(fileEdit->text());
    }
    
    if(!stateFileEdit->text().isEmpty())
    {
	simulate_cmd += " -stateFile ";
	simulate_cmd += static_cast<const char*>(stateFileEdit->text());
    }
    
    //Cycles must be last if it is present, because the TCL command processes cycles, not the simulator
	//for cycle simulation we want to start with 0 cycles
       simulate_cmd += " -cycles 0 ";
    //Cycles must be last if it is present, because the TCL command processes cycles, not the simulators
    
    emit runSimulationPressed(simulate_cmd);
    close();
}

void runCycleSimulationFormT::selectLibertyDialog()
{
    QFileDialog * fileDialog = new QFileDialog(this);
    fileDialog->setModal(true);
    fileDialog->exec();
    QString filename = fileDialog->selectedFile();
    libertyEdit->setText(filename);

    delete fileDialog;
}

void runCycleSimulationFormT::selectInputSlot()
{
    QFileDialog * fileDialog = new QFileDialog(this);
    fileDialog->setModal(true);
    fileDialog->exec();
    QString filename = fileDialog->selectedFile();
    fileEdit->setText(filename);

    delete fileDialog;

}



void runCycleSimulationFormT::selectStateFileSlot()
{
    QFileDialog * fileDialog = new QFileDialog(this);
    fileDialog->setModal(true);
    fileDialog->exec();
    QString filename = fileDialog->selectedFile();
    stateFileEdit->setText(filename);

    delete fileDialog;    
}
