/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#include <iostream>
#include <iomanip>

#include <qtable.h>
#include <qlineedit.h>

#include "infoPlugIn.h"
#include "QoagCommon/QoagCommonTempl.h"

#include <assert.h>
#include "oaDesignDB.h"
#include "oagUtilOption.h"
#include "oagUtilOptionParser.h"

using std::vector;
using std::string;

int InfoCmd(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[])
{
    static_cast<void>(clientData);
    static_cast<void>(interp);

    oagUtil::OptionParser options(
                 "Give information about an OpenAccess design");

    oagUtil::Option *libOpt = 
       options.add("lib", "Input library name", true, "library");
    oagUtil::Option *cellOpt = 
       options.add("cell", "Input cell name", true, "cell");
    oagUtil::Option *viewOpt = 
      options.add("view", "Input view name", true, "view");

    if (!options.parse(argc, argv)) {
        std::cerr << options.getMessage();
    }

    try {
        const oa::oaNativeNS nativeNS;
        const oa::oaScalarName cellName(nativeNS, cellOpt->getValue());
        const oa::oaScalarName libName(nativeNS, libOpt->getValue());
        const oa::oaScalarName viewName(nativeNS, viewOpt->getValue());

        // take top level cellView
        oa::oaDesign *cv = oa::oaDesign::open(libName, cellName, viewName, 'r');
        assert(cv);

        oa::oaBlock *block = cv->getTopBlock();
        if(block)
        cout<<"Number of oaInsts: "<<block->getInsts().getCount()<<
              " oaNets: "<< block->getNets().getCount()<<
              " oaInstTerms: "<< block->getInstTerms().getCount()<<
              " oaTerms: "<< block->getTerms().getCount()<<
              " oaPins: "<< block->getPins().getCount()<<
              " oaRoutes: "<< block->getRoutes().getCount()<<
               endl;


    }

    catch (oa::oaException &e) {
        std::cerr << "ERROR: " << e.getMsg() << std::endl;
        return 1;
    }

    return TCL_OK;
}


oagBazaar::oagBazaarPlugInInterface * newPlugIn(void)
{
    InfoPlugIn* plugIn = new InfoPlugIn; //memory leak!
    return plugIn;
}


void InfoPlugIn::load(std::auto_ptr<oagBazaar::oagBazaarPlugInAPI> bazaarAPI)
{
   //DO THIS FIRST BEFORE ANYTHING ELSE 
   _bazaarAPI = bazaarAPI; //take ownership of the API object pointer

   _bazaarAPI->registerTCLCommand(&InfoCmd, "info");

   //QPopupMenu* timerMenu = _bazaarAPI->addMenu("Timer");
   //QToolBar* timerToolBar = _bazaarAPI->addToolBar("Timer Tool Bar");

   //QAction* runTimerAction = _bazaarAPI->createAction("run_timer", "Run OAGear Timer", "Run OAGear's Timer.", "stopwatch_icon.png");

   //_bazaarAPI->addMenuItem(timerMenu, runTimerAction);
   //_bazaarAPI->addToolBarButton(timerToolBar, runTimerAction);

}



