/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2005-11-07: ChangeLog started
 */

/*! \file OAGearCommon.h */

#ifndef _OAGEARCOMMON_H_
#define _OAGEARCOMMON_H_

#include<ostream>
#include "oaDesignDB.h"

namespace oagBazaar
{

    ///Print an oaBox on a std::ostream
    std::ostream& operator<<(std::ostream& os, const oa::oaBox& box);

    ///This function will save a newly created library's path in the user's current lib.defs file.
    void updateLibDefsFile(oa::oaScalarName libraryName, oa::oaString libraryPath);

    ///This function will traverse an oaLibDefList and return the first library database path it finds
    oa::oaString getLibraryPath(oa::oaLibDefList *list);
    
}

#endif


