# Sample script for running sizing experiments
source source.tcl
source prepsizing.tcl

set fidsl [open "sizing.log" "w"]

# find the approximate minimum delay
set t0 [clock seconds]
greedySizingTiming
set t1 [clock seconds]
set md [saveCurrentSizing]


writeIterateInfo "Min Delay" $fidsl
puts $fidsl "Elapsed time [expr $t1-$t0]s"

# set the minimum delay
set dmin [getMaxDelay]

minimumSize
set dmax [getMaxDelay]
writeIterateInfo "Max Delay" $fidsl

# adjust the clock period
set cc [all_clocks]
set cclock [index_collection $cc 0]
set cname [get_property $cclock hierarchical_name]
create_clock -period [expr $dmin + $DFACTOR*($dmax-$dmin)] -name $cname

# greedy sizing
minimumSize
set t0 [clock seconds]
greedySizingPower 
set t1 [clock seconds]
writeIterateInfo "Greedy Sizing Power" $fidsl
puts $fidsl "Elapsed time [expr $t1-$t0]s"

restoreSizing $md
writeIterateInfo "Pre Greedy Sizing Recover Power" $fidsl
set t0 [clock seconds]
greedySizingRecoverPower
set t1 [clock seconds]
writeIterateInfo "Greedy Sizing Recover Power" $fidsl
puts $fidsl "Elapsed time [expr $t1-$t0]s"

restoreSizing $md
writeIterateInfo "Pre-LP Slack Allocation" $fidsl
set t0 [clock seconds]
LPSlackAllocation
set t1 [clock seconds]
writeIterateInfo "LP Slack Allocation" $fidsl
puts $fidsl "Elapsed time [expr $t1-$t0]s"

close $fidsl
exit


