function [Xf,num_points_return,Jf]=Gradient_descent(w_1, w_2, Xc, Rt, trust_int_v, trust_int_w, Derivative, num, optimizing_stage_weight, flag_vdd,flag_vt,vdd_allocation,vt_allocation,ub_i,lb_i, mode, max_limit_metric, metric_scale)

%%%%%Debug testing
% Xc=[1 2 3 4 0 0;1 3 4 5 6 7]';
% w_1=1/2;
% w_2=1/2;
% ub_i=[2 3 4 5 0 0; 2 4 5 6 7 8]';
% lb_i=[0 1 2 3 0 0; 0 2 3 4 5 6]';
% Derivative(1).d_D=[2;1;3;4];
% Derivative(2).d_D=[1;1;2;2;2;2];
% Derivative(1).d_D2=[1 2 3 4;2 1 3 4;3 3 1 1; 4 4 1 1];
% Derivative(2).d_D2=ones(6,6);
% Derivative(1).d_E=[2;1;3;4];
% Derivative(2).d_E=[1;1;2;2;2;2];
% Derivative(1).d_E2=[1 2 3 4;2 1 3 4;3 3 1 1; 4 4 1 1];
% Derivative(2).d_E2=ones(6,6);
% Derivative(1).D(1)=1;
% Derivative(1).E(1)=1;
% Derivative(2).D(1)=2;
% Derivative(2).E(1)=2;
% optimizing_stage_weight=[1 2];
% vdd_allocation=[1 2];
% vt_allocation=[1;2];
% num=[2 4];
% flag_vdd=1;
% flag_vt=1;
%%%%%%%%%%%%% Set ub_i and lb_i to ensure gradient descent in model region

%%%%%%%%%%%%% 
num_points=5;
num_points_return=2*num_points;
n_norm=200;
plus_delay=12;
a=0.1;
b=0.75;
M=0;
n_bins=length(num);
Df=-0.5;
n=n_norm;
for i_stage=1:n_bins
    D(num(i_stage)/2)=Derivative(i_stage).D(1);
    E(num(i_stage)/2)=Derivative(i_stage).E(1);
    W(num(i_stage)/2)=optimizing_stage_weight(i_stage);
end
%%%%%%%%%%%%%%%%%%%Gradient and Hessian calculation
G_D=[];
G_P=[];
H_D=[];
H_P=[];
n_v=0;
delay_base=0;
power_base=0;
for i_stage=1:n_bins   %%% delay and power base are formular used in G and H calculations
    current_D=Derivative(i_stage).D(1);
    current_E=Derivative(i_stage).E(1);
    delay_base=delay_base+(plus_delay+current_D)^n_norm;
    power_base=power_base+optimizing_stage_weight(i_stage)*10^(current_E);
end
n_vdd=0;
n_vt=0;
%%%%%%Calculate Gradient vector; 
%%%%%Variable orders:
%%%%%vdd1,vdd2,...,vddn,vt1,vt2,...,vtn,w11,w12,..w1n,w21,..,wnn
if(flag_vdd)
    for i=1:length(vdd_allocation(:,1))
        n_v=n_v+1;
        G_D(n_v,1)=0;
        G_E(n_v,1)=0;
        G_A(n_v,1)=0;
        id_=find(num==(vdd_allocation(i,1)*2));
        Xi(n_v,1)=Xc(1,id_);
        ub(n_v,1)=ub_i(1,id_);
        lb(n_v,1)=lb_i(1,id_);
        trust_radius(n_v,1)=trust_int_v;
        for j=1:length(find(vdd_allocation(i,:)>0))
            id=vdd_allocation(i,j);
            G_D(n_v,1)=G_D(n_v,1)+delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-1)*Derivative(id).d_D(1,1);
            G_P(n_v,1)=G_E(n_v,1)+optimizing_stage_weight(id)*10^(E(id))*Derivative(id).d_E(1,1)/power_base;
        end
    end
    n_vdd=n_v;
end
if(flag_vt)
    for i=1:length(vt_allocation(:,1))
        n_v=n_v+1;
        G_D(n_v,1)=0;
        G_E(n_v,1)=0;
        G_A(n_v,1)=0;
        id_=find(num==(vt_allocation(i,1)*2));
        Xi(n_v,1)=Xc(2,id_);
        ub(n_v,1)=ub_i(2,id_);
        lb(n_v,1)=lb_i(2,id_);
        trust_radius(n_v,1)=trust_int_v;
        for j=1:length(find(vt_allocation(i,:)>0))
            id=vt_allocation(i,j);
            G_D(n_v,1)=G_D(n_v,1)+delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-1)*Derivative(id).d_D(2,1);
            G_P(n_v,1)=G_E(n_v,1)+optimizing_stage_weight(id)*10^(E(id))*Derivative(id).d_E(2,1)/power_base;
        end
    end
    n_vt=n_v;
end
for i_stage=1:n_bins
    for i=1:num(i_stage)
        id=num(i_stage)/2;
        n_v=n_v+1;
        Xi(n_v,1)=Xc(i+2,i_stage);
        ub(n_v,1)=ub_i(i+2,i_stage);
        lb(n_v,1)=lb_i(i+2,i_stage);
        trust_radius(n_v,1)=trust_int_w;
        G_D(n_v,1)=delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-1)*Derivative(id).d_D(2+i,1);
        G_P(n_v,1)=optimizing_stage_weight(id)*10^(E(id))*Derivative(id).d_E(2+i,1)/power_base;
        G_A(n_v,1)= Derivative(id).d_A(2+i,1);
    end
end

%%%%%Calculate Hession matrix
if(flag_vdd)
    for i=1:length(vdd_allocation(:,1))
        H_D(i,i)=0;
        H_P(i,i)=0;
        for j=1:length(find(vdd_allocation(i,:)>0))%%%%%d2D/dvdd2
            id=vdd_allocation(i,j);
            for j2=1:length(find(vdd_allocation(i,:)>0))
                id2=vdd_allocation(i,j2);
                H_D(i,i)=H_D(i,i)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id))^(n_norm-1)*(plus_delay...
                    +D(id2))^(n_norm-1)*Derivative(id).d_D(1,1)*Derivative(id2).d_D(1,1);
                H_P(i,i)=H_P(i,i)-log(10)*W(id2)*10^E(id2)*W(id)*10^E(id)*Derivative(id2).d_E(1,1)...
                    *Derivative(id).d_E(1,1)/power_base^2;
            end
            H_D(i,i)=H_D(i,i)+(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-2)*Derivative(id).d_D(1,1)^2 ...
                   +delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-1)*Derivative(id).d_D2(1,1);
            H_P(i,i)=H_P(i,i)+log(10)*W(id)*10^E(id)*(Derivative(id).d_E(1,1))^2/power_base+W(id)*10^E(id)*Derivative(id).d_E2(1,1)/power_base;
        end
        for j=i+1:length(vdd_allocation(:,1)) %%%%d2D/(dvdd1 dvdd2)
            H_D(i,j)=0;
            H_P(i,j)=0;
            for j1=1:length(find(vdd_allocation(i,:)>0))
                id1=vdd_allocation(i,j1);
                for j2=1:length(find(vdd_allocation(j,:)>0))
                    id2=vdd_allocation(j,j2);
                    H_D(i,j)=H_D(i,j)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)...
                        *Derivative(id1).d_D(1,1)*Derivative(id2).d_D(1,1);
                    H_P(i,j)=H_P(i,j)-log(10)*W(id2)*10^E(id2)*W(id1)*10^E(id1)*Derivative(id2).d_E(1,1)...
                    *Derivative(id1).d_E(1,1)/power_base^2;
                end
            end
        end
        for j=1:length(vt_allocation(:,1))%%%%d2D/dvdd1 dvt1
            H_D(i,n_vdd+j)=0;
            H_P(i,n_vdd+j)=0;
            for j1=1:length(find(vdd_allocation(i,:)>0))
                for j2=1:length(find(vt_allocation(j,:)>0))
                    id1=vdd_allocation(i,j1);
                    id2=vt_allocation(j,j2);
                    H_D(i,n_vdd+j)=H_D(i,n_vdd+j)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)...
                        *Derivative(id1).d_D(1,1)*Derivative(id2).d_D(2,1);
                    H_P(i,n_vdd+j)=H_P(i,n_vdd+j)-log(10)*W(id2)*10^E(id2)*W(id1)*10^E(id1)*Derivative(id2).d_E(2,1)...
                    *Derivative(id1).d_E(1,1)/power_base^2;
                    if(id1==id2)
                        H_D(i,n_vdd+j)=H_D(i,n_vdd+j)+(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-2)*Derivative(id1).d_D(1,1)...
                            *Derivative(id1).d_D(2,1)+delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-1)*Derivative(id1).d_D2(1,2);
                        H_P(i,n_vdd+j)=H_P(i,n_vdd+j)+log(10)*W(id1)*10^E(id1)*Derivative(id1).d_E(1,1)*Derivative(id1).d_E(2,1)...
                            /power_base+W(id1)*10^E(id1)*Derivative(id1).d_E2(1,2)/power_base;
                    end
                end
            end
        end
        c_i=n_vt;
        for i_stage=1:n_bins %%% d2D/dvdd1 dw1
            id2=num(i_stage)/2;
            for j=1:num(i_stage)
                c_i=c_i+1;
                H_D(i,c_i)=0;
                H_P(i,c_i)=0;
                for j2=1:length(find(vdd_allocation(i,:)>0))
                    id1=vdd_allocation(i,j2);
                    H_D(i,c_i)=H_D(i,c_i)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)...
                        *Derivative(id1).d_D(1,1)*Derivative(id2).d_D(2+j,1);                    
                    H_P(i,c_i)=H_P(i,c_i)-log(10)*W(id2)*10^E(id2)*W(id1)*10^E(id1)*Derivative(id2).d_E(2+j,1)...
                    *Derivative(id1).d_E(1,1)/power_base^2;
                    if(id1==id2)
                        H_D(i,c_i)=H_D(i,c_i)+(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-2)*Derivative(id1).d_D(1,1)...
                            *Derivative(id1).d_D(2+j,1)+delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-1)*Derivative(id1).d_D2(1,2+j);                  
                        H_P(i,c_i)=H_P(i,c_i)+log(10)*W(id1)*10^E(id1)*Derivative(id1).d_E(1,1)*Derivative(id1).d_E(2+j,1) /power_base+W(id1)*10^E(id1)*Derivative(id1).d_E2(1,2+j)/power_base;
                    end
                end
            end
        end
    end
end
if(flag_vt)
    for i=1:length(vt_allocation(:,1))
        H_D(n_vdd+i,n_vdd+i)=0;
        H_P(n_vdd+i,n_vdd+i)=0;
        for j=1:length(find(vt_allocation(i,:)>0))%%%%%d2D/dvt2
            id=vt_allocation(i,j);
            for j2=1:length(find(vt_allocation(i,:)>0))
                id2=vt_allocation(i,j2);
                H_D(n_vdd+i,n_vdd+i)=H_D(n_vdd+i,n_vdd+i)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id))^(n_norm-1)*(plus_delay...
                    +D(id2))^(n_norm-1)*Derivative(id).d_D(2,1)*Derivative(id2).d_D(2,1);
                H_P(n_vdd+i,n_vdd+i)=H_P(n_vdd+i,n_vdd+i)-log(10)*W(id2)*10^E(id2)*W(id)*10^E(id)*Derivative(id2).d_E(2,1)...
                    *Derivative(id).d_E(2,1)/power_base^2;
            end
            H_D(n_vdd+i,n_vdd+i)=H_D(n_vdd+i,n_vdd+i)+(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-2)*Derivative(id).d_D(2,1)^2 ...
                +delay_base^(1/n_norm-1)*(plus_delay+D(id))^(n_norm-1)*Derivative(id).d_D2(2,2);
            H_P(n_vdd+i,n_vdd+i)=H_P(n_vdd+i,n_vdd+i)+log(10)*W(id)*10^E(id)*(Derivative(id).d_E(2,1))^2/power_base+W(id)*10^E(id)*Derivative(id).d_E2(2,2)/power_base;
        end
        for j=i+1:length(vt_allocation(:,1)) %%%%d2D/(dvt1 dvt2)
            H_D(n_vdd+i,n_vdd+j)=0;
            H_P(n_vdd+i,n_vdd+j)=0;
            for j1=1:length(find(vt_allocation(i,:)>0))
                id1=vt_allocation(i,j1);
                for j2=1:length(find(vt_allocation(j,:)>0))
                    id2=vt_allocation(j,j2);
                    H_D(n_vdd+i,n_vdd+j)=H_D(n_vdd+i,n_vdd+j)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)...
                        *Derivative(id1).d_D(2,1)*Derivative(id2).d_D(2,1);
                    H_P(n_vdd+i,n_vdd+j)=H_P(n_vdd+i,n_vdd+j)-log(10)*W(id2)*10^E(id2)*W(id1)*10^E(id1)*Derivative(id2).d_E(2,1)...
                    *Derivative(id1).d_E(2,1)/power_base^2;
                end
            end
        end
        c_i=n_vt;
        for i_stage=1:n_bins %%% d2D/dvdd1 dw1
            id2=num(i_stage)/2;
            for j=1:num(i_stage)
                c_i=c_i+1;
                H_D(n_vdd+i,c_i)=0;
                H_P(n_vdd+i,c_i)=0;
                for j2=1:length(find(vt_allocation(i,:)>0))
                    id1=vt_allocation(i,j2);
                    H_D(n_vdd+i,c_i)=H_D(n_vdd+i,c_i)+(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)...
                        *Derivative(id1).d_D(2,1)*Derivative(id2).d_D(2+j,1);
                    H_P(n_vdd+i,c_i)=H_P(n_vdd+i,c_i)-log(10)*W(id2)*10^E(id2)*W(id1)*10^E(id1)*Derivative(id2).d_E(2+j,1)...
                    *Derivative(id1).d_E(2,1)/power_base^2;
                    if(id1==id2)
                        H_D(n_vdd+i,c_i)=H_D(n_vdd+i,c_i)+(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-2)*Derivative(id1).d_D(2,1)...
                            *Derivative(id1).d_D(2+j,1)+delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-1)*Derivative(id1).d_D2(2,2+j);                  
                        H_P(n_vdd+i,c_i)=H_P(n_vdd+i,c_i)+log(10)*W(id1)*10^E(id1)*Derivative(id1).d_E(2,1)*Derivative(id1).d_E(2+j,1)/power_base+W(id1)*10^E(id1)*Derivative(id1).d_E2(2,2+j)/power_base;

                    end
                end
            end
        end
    end
end 
c_i=n_vt;
for i_stage=1:n_bins
    id1=num(i_stage)/2;
    for j1=1:num(i_stage)
        c_i=c_i+1;
        for j2=j1:num(i_stage)
            H_D(c_i,c_i+j2-j1)=(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(2*(n_norm-1))*Derivative(id1).d_D(2+j1,1)*Derivative(id1).d_D(2+j2,1)...
                +(n_norm-1)*delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-2)*Derivative(id1).d_D(2+j1,1)*Derivative(id1).d_D(2+j2,1)...
                +delay_base^(1/n_norm-1)*(plus_delay+D(id1))^(n_norm-1)*Derivative(id1).d_D2(2+j1,2+j2);
            H_P(c_i,c_i+j2-j1)=-log(10)*(W(id1)*10^E(id1))^2*Derivative(id1).d_E(2+j1)*Derivative(id1).d_E(2+j2,1)/power_base^2 ...
                +log(10)*W(id1)*10^E(id1)*Derivative(id1).d_E(2+j1,1)*Derivative(id1).d_E(2+j2,1)/power_base...
                +W(id1)*10^E(id1)*Derivative(id1).d_E2(2+j1,2+j2)/power_base;
        end
        c_j=c_i+num(i_stage)-j1;
        for i2=i_stage+1:n_bins
            id2=num(i2)/2;
            for j2=1:num(i2)
                c_j=c_j+1;
                H_D(c_i,c_j)=(1-n_norm)*delay_base^(1/n_norm-2)*(plus_delay+D(id1))^(n_norm-1)*(plus_delay+D(id2))^(n_norm-1)*Derivative(id1).d_D(2+j1,1)*Derivative(id2).d_D(2+j2,1);
                H_P(c_i,c_j)=-log(10)*W(id1)*10^E(id1)*W(id2)*10^E(id2)*Derivative(id1).d_E(2+j1,1)*Derivative(id2).d_E(2+j2,1)/power_base^2;
            end
        end
    end
end
for i=2:length(Xi)
    for j=1:i-1
        H_D(i,j)=H_D(j,i);
        H_P(i,j)=H_P(j,i);
    end
end
switch mode
    case 1
        f = w_1*(delay_base^(1/n_norm)-plus_delay)+w_2*log10(power_base);
    case 2
        f = w_1*(delay_base^(1/n_norm)-plus_delay)+w_2*Derivative(1).area;
    case 3
        f = w_1*Derivative(1).area + w_2 * log10(power_base);
end
switch mode
    case 1
        G=G_D*w_1+G_P*w_2;
        H=H_D*w_1+H_P*w_2;
    case 2
        G=G_D*w_1+G_A*w_2;
        H=H_D*w_1;
    case 3
        G=G_A*w_1+G_P*w_2;
        H=H_P*w_2;
end
X1=Xi;
X2=Xi;
f1=f;
f2=f;
trust_ub=zeros(size(Xi));
trust_lb=zeros(size(Xi));
for i_rt=1:num_points
    trust_ub(1:n_vt,1)=Xi(1:n_vt,1)+trust_radius(1:n_vt,1)*Rt/num_points*i_rt;
    trust_lb(1:n_vt,1)=Xi(1:n_vt,1)-trust_radius(1:n_vt,1)*Rt/num_points*i_rt;
    trust_ub(n_vt+1:length(Xi),1)=Xi(n_vt+1:length(Xi),1).*(1+trust_radius(n_vt+1:length(Xi),1)*Rt/num_points*i_rt);
    trust_lb(n_vt+1:length(Xi),1)=Xi(n_vt+1:length(Xi),1).*(1-trust_radius(n_vt+1:length(Xi),1)/4*Rt/num_points*i_rt);
    %%%%%Newton method
    G1=G+H*(X1-Xi);
 
    switch mode
        case 1
            [X1, f1]=Logarithmic_barrier_N(X1,f1,G1,H,min(ub,trust_ub),max(lb,trust_lb),G_A,zeros(size(H_D)),max_limit_metric - Derivative(1).area );
        case 2
            [X1, f1]=Logarithmic_barrier_N(X1,f1,G1,H,min(ub,trust_ub),max(lb,trust_lb),G_P, H_P , log10(max_limit_metric * metric_scale) - log10(power_base));
        case 3
            [X1, f1]=Logarithmic_barrier_N(X1,f1,G1,H,min(ub,trust_ub),max(lb,trust_lb),G_D, H_D , log10(max_limit_metric * metric_scale) - (delay_base^(1/n_norm) -plus_delay) );
    end
    if(flag_vdd)
        for i_vdd=1:length(vdd_allocation(:,1))
            for i_id=1:length(find(vdd_allocation(i_vdd,:)>0))
                id=find(num==(vdd_allocation(i_vdd,i_id)*2));
                Xf(i_rt*2-1).X(1,id)=X1(i_vdd,1);
            end
        end
    else
        n_vdd=length(vdd_allocation(:,1));
        for i_vdd=1:length(vdd_allocation(:,1))
            for i_id=1:length(find(vdd_allocation(i_vdd,:)>0))
                id=find(num==(vdd_allocation(i_vdd,i_id)*2));
                Xf(i_rt*2-1).X(1,id)=Xc(1,id);
            end
        end
        n_vdd=0;
    end
    if(flag_vt)
        for i_vt=1:length(vt_allocation(:,1))
            for i_id=1:length(find(vt_allocation(i_vt,:)>0))
                id=find(num==(vt_allocation(i_vt,i_id)*2));
                if(abs(X1(n_vdd+i_vt,1))<0.001)
                    Xf(i_rt*2-1).X(2,id)=0;
                else
                    Xf(i_rt*2-1).X(2,id)=X1(n_vdd+i_vt,1);
                end
            end
        end
    else
        for i_vt=1:length(vt_allocation(:,1))
            for i_id=1:length(find(vt_allocation(i_vt,:)>0))
                id=find(num==(vt_allocation(i_vt,i_id)*2));
                Xf(i_rt*2-1).X(2,id)=Xc(2,id);
            end
        end
        n_vt=n_vdd;
    end
    c_i=n_vt;
    for i_stage=1:n_bins
        for i_w=1:num(i_stage)
            c_i=c_i+1;
            Xf(i_rt*2-1).X(2+i_w,i_stage)=X1(c_i,1);
        end
    end
    Jf(i_rt*2-1,1)=delay_base^(1/n_norm)-plus_delay+(X1-Xi)'*G_D+1/2*(X1-Xi)'*H_D*(X1-Xi);
    Jf(i_rt*2-1,2)=log10(power_base)+(X1-Xi)'*G_P+1/2*(X1-Xi)'*H_P*(X1-Xi)-Jf(i_rt*2-1,1);
    Jf(i_rt*2-1,5)=Derivative(1).area + (X1-Xi)'*G_A;
    %%%%%%%%%%%%Gradient method
    G2=G+H*(X2-Xi);
    switch mode
        % metric is used to scale max power or delay up in mode 2's logarithmic barrier method to avoid model error
        case 1
            [X2, f2]=Logarithmic_barrier_G(X2,f2,G2,H,min(ub,trust_ub),max(lb,trust_lb), G_A,zeros(size(H_D)),max_limit_metric - Derivative(1).area);
        case 2
            [X2, f2]=Logarithmic_barrier_G(X2,f2,G2,H,min(ub,trust_ub),max(lb,trust_lb), G_P, H_P , log10(max_limit_metric * metric_scale) - log10(power_base));
        case 3
            [X2, f2]=Logarithmic_barrier_N(X2,f2,G2,H,min(ub,trust_ub),max(lb,trust_lb), G_D, H_D , log10(max_limit_metric * metric_scale) - (delay_base^(1/n_norm) -plus_delay) );
    end
    if(flag_vdd)
        for i_vdd=1:length(vdd_allocation(:,1))
            for i_id=1:length(find(vdd_allocation(i_vdd,:)>0))
                id=find(num==(vdd_allocation(i_vdd,i_id)*2));
                Xf(i_rt*2).X(1,id)=X2(i_vdd,1);
            end
        end
    else
        for i_vdd=1:length(vdd_allocation(:,1))
            for i_id=1:length(find(vdd_allocation(i_vdd,:)>0))
                id=find(num==(vdd_allocation(i_vdd,i_id)*2));
                Xf(i_rt*2).X(1,id)=Xc(1,id);
            end
        end
        n_vdd=0;
    end
    if(flag_vt)
        for i_vt=1:length(vt_allocation(:,1))
            for i_id=1:length(find(vt_allocation(i_vt,:)>0))
                id=find(num==(vt_allocation(i_vt,i_id)*2));
                if(abs(X2(n_vdd+i_vt,1))<0.001)
                    Xf(i_rt*2).X(2,id)=0;
                else
                    Xf(i_rt*2).X(2,id)=X2(n_vdd+i_vt,1);
                end
            end
        end
    else
        for i_vt=1:length(vt_allocation(:,1))
            for i_id=1:length(find(vt_allocation(i_vt,:)>0))
                id=find(num==(vt_allocation(i_vt,i_id)*2));
                Xf(i_rt*2).X(2,id)=Xc(2,id);
            end
        end
        n_vt=n_vdd;
    end
    c_i=n_vt;
    for i_stage=1:n_bins
        for i_w=1:num(i_stage)
            c_i=c_i+1;
            Xf(i_rt*2).X(2+i_w,i_stage)=X2(c_i,1);
        end
    end
    Jf(i_rt*2,1)=delay_base^(1/n_norm)-plus_delay+(X2-Xi)'*G_D+1/2*(X2-Xi)'*H_D*(X2-Xi);
    Jf(i_rt*2,2)=log10(power_base)+(X2-Xi)'*G_P+1/2*(X2-Xi)'*H_P*(X2-Xi)-Jf(i_rt*2,1);
    Jf(i_rt*2,5)=Derivative(1).area + (X1-Xi)'*G_A;
end
