//*********************************************************
//This code creates prohibited rectangles, writes out a new GDS for PB only and estimates critical area for 
//based on taking only discrete solutions (inclusion-exclusion) or by Karp's randomized approach
//Started in March 2012
//Written by Abde Ali
//**********************************************************************

#include <fstream>
#include <iostream>
#include <string>
#include<algorithm>
#include<vector>
#include<list>
#include<cmath>
#include<utility>
#include "omp.h"


#include "oaDesignDB.h"
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/uniform_int_distribution.hpp>

#include "Eigen/Dense"
#include "Eigen/LU"

#include "MeasureCodePerf.h"
#include "ManufacturingParams.h"

#include "defectType.h"
#include "findProhibitedRects.h"
#include "fftInterface.h"
#include "FeatureExtraction.h"

using namespace std;
using namespace oa;
//using namespace boost::polygon::operators;
//using namespace boost::polygon;
//using namespace Eigen;


typedef boost::polygon::polygon_90_with_holes_data<double> boostPolygon;
typedef boost::polygon::polygon_90_data<double> boostPolygon_withoutHoles;
typedef boost::polygon::rectangle_data<double> boostRectangle;
typedef list<boostPolygon>  boostPolygonSet;
typedef boost::polygon::point_data<double> boostPoint;

typedef Eigen::MatrixXcf MatrixXcf;
typedef Eigen::MatrixXf MatrixXf;
typedef Eigen::VectorXf VectorXf;


//***************************************************************************
//Global variables
//***************************************************************************
int dbu2UUScale = 1000;
bool debug=false;

//*******************************************************************************************
//This function reports the number of shapes in the input LPPHeader
//*******************************************************************************************
int reportShapeCount(oaLPPHeader *lppHeader){
if (lppHeader->getShapes().isEmpty()) return 0;
else {
   int count = 0;
   oaIter<oaShape> shapes(lppHeader->getShapes());
   while (oaShape *shape = shapes.getNext()){
      oaType type;
      type = shape->getType();
      oaPolygon *poly;
      if (type.getName()=="Polygon") poly = static_cast<oaPolygon*>(shape);
      if (type.getName() == "Rect"){ 
          oaRect *rect = static_cast<oaRect*>(shape);
	  poly = rect->convertToPolygon();
	}
      oaPointArray points;
      poly->getPoints(points);
      if (points.hasExtraPoints()) cout<<"Error: Shapes have coincident or colinear points"<<endl;	  
      count++;
   }
   return count; 

}


}


//******************************************************************************************
//reportShapeStats(): Returns mean and variance of polygons in both X and Y directions
//******************************************************************************************
void reportShapeStats(list<boostPolygon> &polygonSet){

int meanX = 0;
int mean2X = 0;
int meanY = 0;
int mean2Y = 0;

int numRects = 0;
//vector<boostPoint>::iterator p = polygon.begin();
list<boostRectangle> rectSet;
//get_rectangles(rectSet.begin(), polygonSet);


//for (list<boostPolygon>::iterator p = polygonSet.begin(); p != polygonSet.end(); p++){
   


//}
//fracture
// for each rectangle
//    meanX += width;
//    mean2X += width*width;
//    meanY += height;
//    mean2Y += height*height;
//    numRects++;


//meanX = meanX/numRects;
//mean2X = mean2X/numRects;
//varX = mean2X - meanX;
//meanY

return;
}


//********************************************************************************************
//readModel(): Reads the linear fitted model for autocorrelation
//********************************************************************************************
void readModel(const string &modelFile, int &pixelSize, string &modelType, vector<float> &weights, string &pcaFile){

ifstream fin(modelFile.c_str());
string line;
//string pcaFile = "none";
if (fin.is_open()){
   while (fin.good()){
      getline(fin, line);
      if (line[0] != '#'){
         char delimiter=':';
         int pos = line.find(delimiter);
         string field = line.substr(0, pos);
         string value = line.substr(pos + 1);
	 if (field == "Pixel size") pixelSize = atoi(value.c_str());
	 else if (field == "Model type") modelType = value;
	 else if (field == "Linear coefficients"){
		vector<string> words;
		ManufacturingParams::getWords(value, words, " ");
		for (vector<string>::iterator s = words.begin(); s != words.end(); s++) weights.push_back(atof(s->c_str()));
	}
	else if (field == "PCA file") pcaFile = value;
	else if (field != "") cout<<"Error:unrecognized linear coefficients"<<endl;
      }	
   }
}

cout<<"Pixel size "<<pixelSize<<endl;
cout<<"Model type "<<modelType<<endl;
cout<<"Number of linear coefficients "<<weights.size()<<endl;
cout<<"pcaFile name: "<<pcaFile<<endl;
//readPCAfile(pcaFile, mean, PC);


return;
}

//*****************************************************************************************
//getCriticalDensity(): Returns the feature set 
//*****************************************************************************************
float getCriticalDensity(const int &pixelSize, const string &modelType, const string &pcaFile, const VectorXf &weights, const int &shiftX, const int &shiftY, const int &chipX, const int &chipY, const vector<defectType> &allProhibitedRegions){

VectorXf features;
int numFeatures = weights.rows();
float PBdensity = 0.0;
FeatureExtraction ftrObj(pixelSize, shiftX, shiftY, chipX, chipY);
ftrObj.GetFeatures(allProhibitedRegions, modelType, pcaFile, numFeatures, features, PBdensity);
float density = features.dot(weights);

cout<<"Expected Prohibited region density: "<<PBdensity<<endl;

//Zero pad weights to same size as autoCorr matrix, fft it. Iterate over it and compute boolean and to add to critical density iff > tol
/*int rows = shiftX/pixelSize;
int cols = shiftY/pixelSize;
complex<float> z(0.0, 0.0);
MatrixXcf fullWeightM(rows, cols);
for (int r = 0; r < rows; r++){
	for (int c = 0; c < cols; c++) fullWeightM(r, c) = z;
}
int numFeatures = weights.rows();
int orders = sqrt(numFeatures - 1);
for (int n = 1; n < numFeatures; n++){
	int r = (n-1)%orders;
	int c = (n-1)/orders;
	fullWeightM(r, c) = weights(n);
}

MatrixXcf fullWeightMF(rows, cols);
getFourier(fullWeightM, fullWeightMF);

float reticleArea = ((float)(chipX + shiftX))*((float)(chipY + shiftY));
float tol = 0.00001;
list<boostPolygon> shiftedProhibitedRegions = prohibitedRegions;
complex<float> density = z;
for (int r = 0; r < rows; r++){
	for (int c = 0; c < cols; c++){
//		if (real(fullWeightMF(r, c)) > tol){
			//compute boolean area and add to density
			int currentShiftX = r*pixelSize;
	                int currentShiftY = c*pixelSize;
        	        move(shiftedProhibitedRegions, currentShiftX, currentShiftY);
                	list<boostPolygon> solutionSpace;
                	solutionSpace |= prohibitedRegions;
                	solutionSpace &= shiftedProhibitedRegions;
                	float value = ((float)area(solutionSpace))/(reticleArea*(rows*cols));
			cout<<"("<<r<<", "<<c<<"): "<<value<<" * "<<abs(fullWeightMF(r, c))<<endl;
			density += value*fullWeightMF(r, c);
//              cout<<"Row "<<r<<" Col "<<c<<" "<<T<<endl;
	                move(shiftedProhibitedRegions, -currentShiftX, -currentShiftY);
        	        solutionSpace.clear();
//		}	 
	}
}
*/
cout<<"Critical density: "<<density<<endl;
return density;
}

//*****************************************************************************
//writeYieldEstimate(): Reads effective density and writes yield for different defect counts
//****************************************************************************
void writeYieldEstimate(const string &designName, const string &layerName, const float &density, const string &outputFile){


ofstream fout(outputFile.c_str());

int minDefect = 10;
int maxDefect = 150;
fout<<"DefectCount,MaskYield"<<endl;
for (int d = minDefect; d <= maxDefect; d += 10){
	float N = (float)d;
	float yield = 0.0;
	if (N < 2.0/(density*density)) yield = 1.0;
	else {
		float gamma = N*N*(density*density*exp(-N*density*density));
		yield = 1.0 - exp(-gamma);	
	}
	fout<<d<<","<<yield<<endl;
}

fout.close();
return;
}


//***************************************************************************
//Returns number of shapes in given layout
//***************************************************************************
void numShapeEdgesAndArea(oaDesign *view, oaLayerNum layerNum, oaPurposeNum purpNum, int &countShapeEdges, int &polygonArea){
oaIter<oaLPPHeader> headers(view->getTopBlock()->getLPPHeaders());
countShapeEdges = 0;
polygonArea = 0;
while (oaLPPHeader *lppHeader = headers.getNext()) {
	oaLayerNum lppLayerNum = lppHeader->getLayerNum();
	oaPurposeNum lppPurpNum = lppHeader->getPurposeNum();
	if (lppLayerNum == layerNum){
		if (!lppHeader->getShapes().isEmpty()) {
			oaIter<oaShape> shapes(lppHeader->getShapes());
			while (oaShape *shape = shapes.getNext()){
				oaType type = shape->getType();
				oaPolygon *poly;
				if (type.getName() == "Polygon"){
					poly = static_cast<oaPolygon*>(shape);
				}
				else if (type.getName() == "Rect") {
					oaRect *rect = static_cast<oaRect*>(shape);
					poly = rect->convertToPolygon();
				}
				oaPointArray points;
				poly->getPoints(points);
				countShapeEdges += points.getNumElements();
				polygonArea += points.getArea();
			}
 		}
	}
}
return;
}

//******************************************************************************************
//Returns all the polygons of given layer in boostPolygon form
//*****************************************************************************************
void getShapes(oaDesign *view, oaLayerNum layerNum, oaPurposeNum purpNum, boostPolygonSet &allShapes){

oaIter<oaLPPHeader> headers(view->getTopBlock()->getLPPHeaders());
while (oaLPPHeader *lppHeader = headers.getNext()) {
	oaLayerNum lppLayerNum = lppHeader->getLayerNum();
	oaPurposeNum lppPurpNum = lppHeader->getPurposeNum();
	if (lppLayerNum == layerNum){
		if (!lppHeader->getShapes().isEmpty()) {
			oaIter<oaShape> shapes(lppHeader->getShapes());
			while (oaShape *shape = shapes.getNext()){
				oaType type = shape->getType();
				oaPolygon *poly;
				if (type.getName() == "Polygon"){
					poly = static_cast<oaPolygon*>(shape);
				}
				else if (type.getName() == "Rect") {
					oaRect *rect = static_cast<oaRect*>(shape);
					poly = rect->convertToPolygon();
				}
				oaPointArray points;
				poly->getPoints(points);
				vector<boostPoint> allBpoints(points.getNumElements());
                                for (int p = 0; p < points.getNumElements(); p++){
                                        allBpoints[p].x(points[p].x());
                                        allBpoints[p].y(points[p].y());
                                }
                                boostPolygon shapeBPoly;
                                set_points(shapeBPoly, allBpoints.begin(), allBpoints.end());
                                allShapes.push_back(shapeBPoly);
			}
		}
	}
}

return;

}


//*******************************************************************************************
//Main function for computing critical density and mask yield of EUV layout
//*******************************************************************************************

int main(int    argc, char   *argv[]){
float nTime = MeasureCodePerf::normalizedTime();
cout<<"Wall time for trial op: "<<nTime<<endl;

float start = omp_get_wtime();
oaDesignInit();
if (argc != 10) {
   cout<<"Incorrrect arguments"<<endl;
   cout<<"Format for running: ./test <modelFile> <designPath> <designName> <designCell> <CDtolerance> <manfFile> <layerName> <PBmode> <outfileName> "<<endl;
   exit(1);
} 
try {
string modelFile = argv[1];
//Read in MIPS GDS

oaRegionQuery::init("oaRQSystem");
oaNativeNS	ns;
oaScalarName	libName(ns, argv[3]);
oaScalarName	cellName(ns, argv[4]);
oaScalarName	viewName(ns, "layout");
oaString	libraryPath(argv[2]);
//        cout<<libraryPath<<" "<<libName<<endl;
if (oaLib::exists(libraryPath)) {
    if (!oaLib::find(libName)) {
	oaLib::open(libName, libraryPath);
    }
} else {
    cout << "Library " << libraryPath << "is not present." << endl;
}

oaDesign *view = oaDesign::open(libName, cellName, viewName, 'r');
oaBlock *block = view->getTopBlock();
int dbu2UUScale = block->getDBUPerUU();
float nm2dbu = dbu2UUScale/1000;
cout<<"DBU per UU "<<dbu2UUScale<<endl; 
oaBox designBox;
block->getBBox(designBox);
int designWidth = designBox.getWidth();
int designHeight = designBox.getHeight();
cout<<"Input design read"<<endl;
//Defining the die dimensions
cout<<"Design width: "<<designWidth<<" Design Height: "<<designHeight<<endl;
int designArea = designWidth*designHeight;
//Read manufacturing parameters
string manfFile = argv[6];
ManufacturingParams manfParamObj(manfFile);

oaTech *techFile = view->getTech();

string layerName = argv[7];
oaLayerNum layerNum;
oaPurposeNum purpNum;

float CDtolerance = atof(argv[5]);
cout<<"Set CD tolerance for defects: "<<CDtolerance<<endl;
int PBmode = atoi(argv[8]);
bool layerIsPB = false;
if (PBmode == 1) layerIsPB = true;
else if (PBmode != 0) cout<<"Error: Invalid PBmode. Must be 0 or 1 "<<endl;
findProhibitedRects PBfinderObj(CDtolerance, layerIsPB);	

if (PBfinderObj.findLayers(techFile, layerName, layerNum, purpNum)){
	//Depending on technology node since design parameters (timing, etc.) are for
	//45nm
	cout<<"Layer num: "<<layerNum<<" purpNum: "<<purpNum<<endl;
//	readCriticalityMap(view, designMode, scaleFactor);
	//Fix mode 0 no change, fix mode 1 means assign higher CD tolerance to dummy and fix mode 2 removes dummy polygons

	int numEdges;
	int polygonArea;
	numShapeEdgesAndArea(view, layerNum, purpNum, numEdges, polygonArea);
	boostPolygonSet layerShapes;
	getShapes(view, layerNum, purpNum, layerShapes);	
	cout<<"Number of shapes: "<<layerShapes.size()<<endl;
	cout<<"Shape Edge Count: "<<numEdges<<endl;
	cout<<"Layout density: "<<((float)polygonArea)/((float)designArea)<<endl;
	MeasureCodePerf::StopWatch(1);
	vector<defectType> allProhibitedRegions;
	PBfinderObj.Run(layerShapes, manfParamObj.GetDefectSizeDist(), manfParamObj.GetDefectHeight(), manfParamObj.GetDefectFWHM(), allProhibitedRegions);
	
	float PRgenTime = MeasureCodePerf::StopWatch(0);
	cout<<"Time taken for poly PR generation "<<PRgenTime<<endl;
//	cout<<"Number of poly PRs "<<polyPRs.size()<<endl;
//	reportShapeStats(polyPRs);
	
	// Read linear regression model (has info on pixel size and number of orders taken)
	MeasureCodePerf::StopWatch(1);
	int pixelSize;
	string modelType;
	vector<float> weights;
	string pcaFile = "none";
        readModel(modelFile, pixelSize, modelType, weights, pcaFile);
	cout<<"Model file read"<<endl;	
	VectorXf weightsE(weights.size());
	for (int w = 0; w != weights.size(); w++) weightsE(w) = weights[w];
        float density = getCriticalDensity(pixelSize, modelType, pcaFile, weightsE, manfParamObj.GetShiftX(), manfParamObj.GetShiftY(), designWidth, designHeight, allProhibitedRegions);
	cout<<"Critical Density: "<<density<<endl;
	// write MCestimates using Janson formula
	string designName = argv[3];
	float effSize = sqrt(density);
	cout<<"Effective size: "<<effSize<<endl;	
        writeYieldEstimate(designName, layerName, effSize, argv[9]);
	float yieldTime = MeasureCodePerf::StopWatch(0);
	cout<<"Runtime for getting yield estimates: "<<yieldTime<<endl;
        view->close();
        cout<<"Layout saved and closed"<<endl;
	cout<<"Total estimated CPU time with 8 cores: "<<(PRgenTime + (1.0/8.0)*yieldTime)<<endl;
}
else cout<<"Error: Input required layer not found"<<endl;
float end = omp_get_wtime();
cout<<"OMP wall clock time: "<<(end - start)<<endl;
cout<<"Normalized OMP wall clock time: "<<(end - start)/nTime<<endl;

}
catch (oaException &excp){
cout<<"Error: "<<excp.getMsg()<<endl;
exit(1);   
}

 return 0;
}
