#include "findProhibitedRects.h"

using namespace std;
using namespace oa;

using namespace boost::polygon::operators;
using namespace boost::polygon;

//******************************************************************************
//This file contains functions to obtain the prohibited regions of a layout
//Written by Abde Ali
//*****************************************************************************
extern bool debug;

typedef point_data<double> boostPoint;
typedef rectangle_data<double> boostRectangle;


findProhibitedRects::findProhibitedRects(const float &CDtol, const bool &mode) {
CDtolerance = CDtol;
PBmode = mode;
}

//******************************************************************************
//This function searches for the layer whose name is input and returns true if the layer exists along with the layer/purpose number
//******************************************************************************
bool findProhibitedRects::findLayers(oaTech *techFile, const string &layerName, oaLayerNum &layerNum, oaPurposeNum &purpNum) const{
oaLayer *layer = NULL;
oaPurpose *purp = NULL;

layer = oaLayer::find(techFile, layerName.c_str());
if (layer == NULL) return false;
layerNum = layer->getNumber();
//cout<<"Layer Name "<<layerName<<" Layer Number "<<layerNum<<endl;
purp = oaPurpose::find(techFile, "ALL");
if (purp == NULL) return false;
purpNum = purp->getNumber();
//cout<<"Purpose number "<<purpNum<<endl;
return true;
}


//*****************************************************************************
//This function displays Boost polygon coordinates
//*****************************************************************************
void findProhibitedRects::displayBoostPolygon(const boostPolygon &polygon) const{
list<boostPoint> pointSet;
pointSet.insert(pointSet.begin(), polygon.begin(), polygon.end());
//vector<boostPoint>::iterator p = polygon.begin();
cout<<"Number of holes "<<polygon.size_holes()<<endl;
for (list<boostPoint>::iterator p = pointSet.begin(); p!=pointSet.end(); p++){
    cout<<"("<<p->x()<<","<<p->y()<<")";
  }
cout<<endl;
return;
}


//****************************************************************************
//Function to get the prohibited regions for one defect size
//****************************************************************************
void findProhibitedRects::RunOneDefectSize(boostPolygonSet &allShapes, const float &defectHeight, const float &defectFWHM, list<boostPolygon> &prohibitedRegions) const{

float A = 3.0*0.5478*0.191/0.0471;
float B = -3.0*0.5478*0.094/0.0471;
int outerDist = 0;
if (A*defectHeight > (CDtolerance - B)) outerDist = round((0.5*defectFWHM)*sqrt(log(A*defectHeight) - log(CDtolerance - B)));
//int outerDist = round((0.5*fwhm)*sqrt(log(A*defectHeight) - log(CDtol - B)));
int innerDist = 0;
if (A*defectHeight > (2*CDtolerance - B)) innerDist = round((0.5*defectFWHM)*sqrt(log(A*defectHeight) - log((2*CDtolerance) - B)));
//if (debug) cout<<"outerDist "<<outerDist<<" innerDist "<<innerDist<<endl;

using namespace boost::polygon::operators;
for (boostPolygonSet::iterator shp = allShapes.begin(); shp != allShapes.end(); shp++){
      	if (PBmode){
		// Mode where layer itself is prohibited region    
         	prohibitedRegions.push_back(*shp);
      	}
   	else {
		vector<boostPoint> points;
		points.insert(points.begin(), shp->begin(), shp->end());
		int N = points.size();
		for (int p=0; p < N; p++){
	        	boostPoint p1 = points[p];
	        	boostPoint p2 = points[(p+1)%N];
	        	long xlow, ylow, xhigh, yhigh;
	         	if (p1.x() == p2.x()){
	         		ylow = min(p1.y(), p2.y()) - outerDist;
	         		yhigh = max(p1.y(), p2.y()) + outerDist;
				int ymid = (ylow+yhigh)/2;
	        		boostRectangle chkBox1(p1.x()+1, ymid, p1.x() + 2, ymid+1);
	        		boostRectangle chkBox2(p1.x()-2, ymid, p1.x() - 1, ymid+1);
				
	         		if (boost::polygon::area(chkBox1 & *shp) > 0){
	                		xlow = p1.x() - outerDist;
	                		xhigh = p1.x() + innerDist;
	            		}
	            		else if (boost::polygon::area(chkBox2 & *shp) > 0) {
	                		xlow = p1.x() - innerDist;
	                		xhigh = p1.x() + outerDist;
	            		}
				else cout<<"Error: Cannot determine if vertical polygon edge at x: " <<p1.x()<<"and ycenter: "<<ymid<<" is left or right"<<endl;
         		}
	         	else if (p1.y() == p2.y()){
	            		xlow = min(p1.x(), p2.x()) - outerDist;
	            		xhigh = max(p1.x(), p2.x()) + outerDist;
				int xmid = (xlow+xhigh)/2;
	            		boostRectangle chkBox1(xmid, p1.y()+1, xmid + 1, p1.y() + 2);
	            		boostRectangle chkBox2(xmid, p1.y()-2, xmid + 1, p1.y() - 1);
	            		if (boost::polygon::area(chkBox1 & *shp) > 0){
	                		ylow = p1.y() - outerDist;
	                		yhigh = p1.y() + innerDist;
	            		}
	            		else if (boost::polygon::area(chkBox2 & *shp) > 0) {
	               			ylow = p1.y() - innerDist;
	               			yhigh = p1.y() + outerDist;
	            		}
				else cout<<"Error: Cannot determine if horizontal polygon edge at y: " <<p1.y()<<"and xcenter: "<<xmid<<" is bottom or top"<<endl;
				
		         }
			 vector<boostPoint> points(4);
		         points[0] = point_data<double>((double)xlow, (double)ylow);
		         points[1] = point_data<double>((double)xhigh, (double)ylow);
			 points[2] = point_data<double>((double)xhigh, (double)yhigh);
			 points[3] = point_data<double>((double)xlow, (double)yhigh);
			 boostPolygon bPoly;
			 bPoly.set(points.begin(), points.end());
	    		 prohibitedRegions.push_back(bPoly);
		}
	}
}	

//Now I need to merge all prohibitedRegions
if (!PBmode){
//   prohibitedRegions = self_xor(tp.allProhibited);
//   prohibitedRegions |= self_intersect(tp.allProhibited);
	prohibitedRegions |= prohibitedRegions;
}

return;
}

//********************************************************************************************
//getAllDefectTypes(): Returns a list of all the defect types (different height, fwhm combinations) with probability
//********************************************************************************************
void findProhibitedRects::getAllDefectTypes(const string &distType, const vector<float> &heightSet, const vector<float> &fwhmSet, vector<defectType> &allDefects) const{

float totProb = 0.0;
for (vector<float>::const_iterator f = fwhmSet.begin(); f != fwhmSet.end(); f++){
	for (vector<float>::const_iterator h = heightSet.begin(); h != heightSet.end(); h++){
		float fwhm = *f;
		float height = *h;
		//Not exactly volume, but propotional to it and thats all we need
		float prob;
        	 float defectVol= (fwhm*fwhm*height);
		if (distType == "inverse") prob = 1.0/defectVol;
		else if (distType == "sqrtinverse") prob = 1.0/sqrt(defectVol);
		else if (distType == "uniform") prob = prob = 1.0;
		else cout<<"Error: distType does not match known types"<<endl;
		defectType dT;
		dT.setHalfWidth(fwhm);
		dT.setHeight(height);
		dT.setProbability(prob);
		allDefects.push_back(dT);
		totProb += prob;
	}
}
//Normalize probabilities
for (vector<defectType>::iterator d = allDefects.begin(); d != allDefects.end(); d++){
	d->setProbability(d->getProbability()/totProb);
}


//sort(allDefects.begin(), allDefects.end(), probPredicate);

}



//*********************************************************************************************
//Top level function to get prohibited regions of different defect sizes
//*********************************************************************************************
void findProhibitedRects::Run(boostPolygonSet &allShapes, const string &distType, const vector<float> &heightSet, const vector<float> &fwhmSet, vector<defectType> &allDefects) const{


getAllDefectTypes(distType, heightSet, fwhmSet, allDefects);
//normalize probabilities and then find PBregions
//#pragma omp parallel for
for (int d = 0; d < allDefects.size(); d++){
	list<boostPolygon> prohibitedRegions;
	RunOneDefectSize(allShapes, allDefects[d].getHeight(), allDefects[d].getHalfWidth(), prohibitedRegions);
	allDefects[d].prohibitedRegions = prohibitedRegions;	
}

return;

}

