#include<fstream>
#include<stdio.h>
#include<stdlib.h> 
#include "ManufacturingParams.h"
using namespace std;
//**************************************************************************************
//getWords() : Small utility function that splits a line into words
//**************************************************************************************
void ManufacturingParams::getWords(string line, vector<string> &words, const string &del){
  int pos = line.find_first_not_of(del);
//  cout<<"First non-space position "<<pos<<endl;
  while (pos != string::npos){
    int nextPos = line.find_first_of(del, pos);
    string wrd = line.substr(pos, (nextPos - pos));
    words.push_back(wrd);
    pos = line.find_first_not_of(del, nextPos);
  }
  return;
}

//*************************************************************************************************************
//This function reads the manufacturing configuration file
//*************************************************************************************************************
ManufacturingParams::ManufacturingParams(const string &manfFile){
ifstream fin(manfFile.c_str());
string line;
if (fin.is_open()){
   while (fin.good()){
      getline(fin, line);
      if (line[0] != '#'){
         char delimiter=':';
         int pos = line.find(delimiter);
         string field = line.substr(0, pos);
         string value = line.substr(pos + 1);
         if (field == "shiftX") shiftX = atoi(value.c_str());
         else if (field == "shiftY") shiftY = atoi(value.c_str());
         else if (field == "defectSizeDistribution") defectSizeDist = value;
         else if (field == "defectHeight"){
                vector<string> heights;
                getWords(value, heights, ",");
                for (int s = 0; s < heights.size(); s++) defectHeight.push_back(atof(heights[s].c_str()));
         }
         else if (field == "defectFWHM"){
                vector<string> widths;
                getWords(value, widths, ",");
                for (int s = 0; s < widths.size(); s++) defectFWHM.push_back(atof(widths[s].c_str()));
        }
         else if (field == "defectUncertainty") defectUncertainty = atoi(value.c_str());
      }
   }
   fin.close();

}


cout<<"Manufacturing parameters"<<endl;
cout<<"shiftArea "<<shiftX<<"X"<<shiftY<<endl;
cout<<"Defect size distribution type: "<<defectSizeDist<<endl;
cout<<"Defect heights: ";
for (int h = 0; h < defectHeight.size(); h++) cout<<defectHeight[h]<<" ";
cout<<endl;
cout<<" Defect FWHM: ";
for (int w = 0; w < defectFWHM.size(); w++) cout<<defectFWHM[w]<<" ";
cout<<endl;

cout<<" Defect Uncertainty "<<defectUncertainty<<endl;


}

int ManufacturingParams::GetShiftX() const{
return shiftX;
}
int ManufacturingParams::GetShiftY() const{
return shiftY;
}
string ManufacturingParams::GetDefectSizeDist() const{
return defectSizeDist;
}
vector<float> ManufacturingParams::GetDefectHeight() const{
return defectHeight;
}

vector<float> ManufacturingParams::GetDefectFWHM() const{
return defectFWHM;
}

int ManufacturingParams::GetDefectUncertainty() const{
return defectUncertainty;
}

