//*********************************************************
//This code implements function to get autocorrelation based feature for a layout. 
//The main top level function is getFeatures() 
// Take PS size, chip size, pixel size and the layout polygons as input
//Started in November 2012
//Written by Abde Ali
//**********************************************************************

#ifndef FTRS_H
#define FTRS_H

#include <iostream>
#include <vector>
#include <string>

#include <boost/polygon/polygon.hpp>
#include "Eigen/Dense"
#include "Eigen/LU"

#include "defectType.h"

typedef boost::polygon::point_data<double> boostPoint;

class FeatureExtraction {

int pixelSize;
int shiftX;
int shiftY;
int chipX;
int chipY;

void dimReductionFFT(const std::vector<Eigen::MatrixXcf> &allAutoCorrelation, const int &numFeatures, Eigen::VectorXf &features) const;
void dimReductionDCT(const std::vector<Eigen::MatrixXcf> &allAutoCorrelation, const int &numFeatures, Eigen::VectorXf &features) const ;
void readPCAfile(const std::string &pcaFile, const int &numFeatures, Eigen::MatrixXf &PC, Eigen::VectorXf &M) const;
void dimReductionPCA(const Eigen::MatrixXcf &autoCorrelation, const std::string &pcaFile, const int &numFeatures, Eigen::VectorXf &features) const;

void dimReductionNone(const Eigen::MatrixXcf &autoCorrelation, Eigen::VectorXf &features) const;
void dimReductionIE(const Eigen::MatrixXcf &autoCorrelation, Eigen::VectorXf &features) const;
float getAutoCorrelationEntry(const std::vector<std::vector<defectType> > &allProhibitedRegionswOrient, const int &angleID) const;
float getAutoCorrelationEntry_approx(const std::vector<defectType> &allProhibitedRegions) const;
void rotatePolygon(const float &angle, const std::vector<boostPoint> &points, std::vector<boostPoint> &newPoints) const;
void getRotatedLayout(const std::vector<defectType> &allProhibitedRegionsBefore, const float &angle, std::vector<defectType> &allProhibitedRegionsAfter) const;

public:

FeatureExtraction(const int &pSize, const int &sX, const int &sY, const int &cX, const int &cY);
void GetFeatures(const std::vector<defectType> &allProhibitedRegions, const std::string &modelType, std::string pcaFile, const int &numFeatures, Eigen::VectorXf &features, float &PBdensity) const;

};
#endif
